/**********************************************************************
** Simple widget that demonstrates the use of QPixmap and QPainter
** to display an image stored in a file.
** The paintEvent() is smart and only updates the part of the widget
** that needs to be redrawn.
** resizeEvent() scales the image so it always fits the widget size.
**********************************************************************/

#ifndef SHOWIMG_H
#define SHOWIMG_H

#include <qwindow.h>
#include <qpixmap.h>


class CuteWidget : public QWindow
{
    Q_OBJECT
public:
    CuteWidget( QWidget *parent=0, const char *name=0 )
	: QWindow( parent, name ) {}

    bool	loadImage( const char *fileName );
protected:
    void	paintEvent( QPaintEvent * );
    void	resizeEvent( QResizeEvent * );
private:
    void	scale();
    QPixmap	pm;			// the loaded pixmap
    QPixmap	pmScaled;		// pixmap scaled to fit widget size
};


#endif // SHOWIMG_H
