/****************************************************************************
** $Id: qwerty.cpp,v 1.4 1997/03/06 14:14:51 paul Exp $
**
** QWERTY - little more than a typewriter
**
*****************************************************************************/

#include "qwerty.h"
#include <qapp.h>
#include <qfile.h>
#include <qfiledlg.h>
#include <qkeycode.h>
#include <qpopmenu.h>
#include <qtstream.h>


Editor::Editor( QWidget * parent , const char * name )
    : QWidget( parent, name )
{
    m = new QMenuBar( this, "menu" );
    QPopupMenu * file = new QPopupMenu();
    CHECK_PTR( file );
    m->insertItem( "&File", file );

    file->insertItem( "New",   this, SLOT(create()), ALT+Key_N );
    file->insertItem( "Open",  this, SLOT(load()),   ALT+Key_O );
    file->insertItem( "Save",  this, SLOT(save()),   ALT+Key_S );
    file->insertSeparator();
    file->insertItem( "Print", this, SLOT(print()),  ALT+Key_P );
    file->insertSeparator();
    file->insertItem( "Quit", qApp,  SLOT(quit()),   ALT+Key_Q );

    e = new QMultiLineEdit( this, "editor" );
}


Editor::~Editor()
{
    // no cleanup necessary
}


void Editor::resizeEvent( QResizeEvent * )
{
    if ( e && m )
	e->setGeometry( 0, m->height(), width(), height() - m->height() );
}


void Editor::load()
{
    QString fn = QFileDialog::getOpenFileName();
    if ( !fn.isEmpty() ) 
	load( fn );
}


void Editor::load( const char *fileName )
{
    QFile f( fileName );
    if ( !f.open( IO_ReadOnly ) )
	return;

    e->setAutoUpdate( FALSE );
    e->clear();

    QTextStream t(&f);
    while ( !t.eof() ) {
	QString s = t.readLine();
	e->append( s );
    }
    f.close();

    e->setAutoUpdate( TRUE );
    e->repaint();
    setCaption( fileName );
}


void Editor::save()
{
    
}


void Editor::create()
{
    
}


void Editor::print()
{
    
}
