open Unix

val read : file_descr -> string -> int -> int -> int
  (* Unix.read wrapper, to be used when data transferred has to
     be counted by the tachymeter
   *)

val fork : unit -> int
  (* Unix.fork wrapper. Catches zombies *)

val add_fileinput : file_descr -> (unit -> unit) -> unit
val remove_fileinput: file_descr -> unit
  (* Wrapping of Tk fileinput functions, with feedback on the tachymeter *)

val init : (int -> unit) -> (bool -> unit) -> unit
  (* [init <pending feedback> <busy feedback>]
   *    connects Low to the tachymeter.
   *)

val bytes_read : int ref
val sample_read: int ref
  (* For the tachymeter *)

val get_bytes_read : unit -> int
val get_sample_read : unit -> int
  (* For applets *)

val busy : ('a -> 'b) -> 'a -> 'b
  (* Busy feedback during this application *)

val global_time : int ref
val add_task : (unit -> unit) -> unit
  (* regular tasks *)
