/*****************************************************************
**
** MathSpad 0.60
**
** Copyright 1996, Eindhoven University of Technology (EUT)
** 
** Permission to use, copy, modify and distribute this software
** and its documentation for any purpose is hereby granted
** without fee, provided that the above copyright notice appear
** in all copies and that both that copyright notice and this
** permission notice appear in supporting documentation, and
** that the name of EUT not be used in advertising or publicity
** pertaining to distribution of the software without specific,
** written prior permission.  EUT makes no representations about
** the suitability of this software for any purpose. It is provided
** "as is" without express or implied warranty.
** 
** EUT DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
** SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
** MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL EUT
** BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
** DAMAGES OR ANY DAMAGE WHATSOEVER RESULTING FROM
** LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
** OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
** OF THIS SOFTWARE.
** 
** 
** Roland Backhouse & Richard Verhoeven.
** Department of Mathematics and Computing Science.
** Eindhoven University of Technology.
**
********************************************************************/
#include "mathpad.h"
#include "system.h"
#include "funcs.h"
#include "sources.h"
#include "output.h"
#include "popup.h"
#include "debug.h"
#include "helpfile.h"

static XSetWindowAttributes popup_attr;
static unsigned long popup_mask;
static XTextProperty wname, iname;
static char *win_name="PopUp";

#define TITLESEL -2

static void popup_bad_end(void *data)
{
    MENU *m= (MENU*) data;

    if (m->freesub) {
	int i;
	for (i=0; i<m->nr; i++) {
	    if (m->line[i].submenu) popup_bad_end(m->line[i].submenu);
	    myfree(m->line[i].txt);
	}
	myfree(m->line);
    }
    if (m->endfunc) (*(m->endfunc))(m->endint);
    if (m->submenu) popup_bad_end(m->submenu);
    destroy_window(m->win_id);
}

static XPoint triangle[4];
static int trsize;

static void draw_line(MENULINE *ml, Window win_id, int ww, int reverse)
{
    int x,y,w,i;
    thinspace(5);
    y=where_y();
    w=0;
    if (reverse && ml->func) set_text_mode(Reverse);
    for (i=0; i<ml->len; i++)
	if (IsNewline(ml->txt[i])) {
	    x=where_x();
	    if (x>w) w=x;
	    thinspace(ww-5-x);
	    out_char(ml->txt[i]);
	    thinspace(5);
	} else
	    out_char(ml->txt[i]);
    x=where_x();
    if (x>w) w=x;
    thinspace(ww-5-x);
    if (reverse && ml->func) set_text_mode(Normal);
    out_char(Newline);
    ml->height=where_y()-y;
    ml->width=w-5;
    if (ml->submenu) {
	triangle[0].x=ww-10;
	triangle[0].y=y+line_height()/2;
	XDrawLines(display,win_id,get_GCXor(PrimSel),triangle,4,CoordModePrevious);
    }
}

static void draw_title(MENU *m, Bool inverse)
{
    if (!m->title) return;
    set_x_y(0,5);
    thinspace(5);
    out_char(Font2Char(FontFont,1));
    out_char(StackB);
    out_char(TopGap);
    if (inverse) set_text_mode(Reverse);
    out_string(m->title);
    if (inverse) set_text_mode(Normal);
    m->tw=where_x()-5;
    thinspace(m->width-m->tw-10);
    out_char(GapBottom);
    out_char(GlueLine);
    out_char(StackClose);
    out_char(Font2Char(PopFont,1));
    out_char(Newline);
    m->th=where_y()-5;
}

static Bool invisible=False;

static void popup_draw(void *data)
{
    MENU *m = (MENU*) data;
    int i=0;
    push_fontgroup(POPUPFONT);
    set_output_window((void*) &m->win_id);
    if (invisible) set_drawstyle(INVISIBLE);
    set_x_y(0,5);
    draw_title(m,m->selline==TITLESEL);
    for (i=0;i<m->nr;i++)
	draw_line(m->line+i, m->win_id, m->width, m->selline==i);
    unset_output_window();
    pop_fontgroup();
}

static void popup_layout_change(void *data)
{
    int i,w=0,h=10,s=0;
    MENU *m = (MENU*) data;
    push_fontgroup(POPUPFONT);
    trsize=line_height()/3; 
    pop_fontgroup();
    triangle[1].y=triangle[3].y=-trsize;
    trsize=trsize*2;
    triangle[1].x=-trsize;
    triangle[3].x=trsize;
    triangle[2].y=trsize;
    triangle[2].x=0;
    if (m) {
	invisible=True;
	popup_draw(data);
	invisible=False;
	w=m->tw;
	for (i=0; i<m->nr; i++) {
	    if (m->line[i].width>w) w=m->line[i].width;
	    h+=m->line[i].height;
	    if (m->line[i].submenu) s++;
	}
	if (m->title) h+=m->th;
	m->width=w+10+(s?8+trsize:0);
	m->height=h;
	XResizeWindow(display, m->win_id, m->width, m->height);
    }
}

static void reselect(MENU *m, int newsel)
{
    int i,h;
    if (newsel == m->selline) return;
    push_fontgroup(POPUPFONT);
    set_output_window((void*) &m->win_id);
    h=m->th;
    i=0;
    while (i<newsel && i<m->nr) h+=m->line[i++].height;	
    set_x_y(0,h+5);
    if (i==newsel) draw_line(m->line+i, m->win_id, m->width, True);
    if (newsel==TITLESEL) draw_title(m,True);
    h=m->th;
    i=0;
    while (i<m->selline && i<m->nr) h+=m->line[i++].height;
    set_x_y(0,h+5);
    if (i==m->selline) draw_line(m->line+i, m->win_id, m->width, False);
    if (m->selline==TITLESEL) draw_title(m,False);
    unset_output_window();
    pop_fontgroup();
    m->selline=newsel;
}

static int dragged;

static void popup_motion(void *data, int x, int y)
{
    MENU *m = (MENU*) data;
    if (m->submenu) {
	MENU *sm;
	sm =m->submenu;
	while (sm) {
	    XDestroyWindow(display, sm->win_id);
	    sm = sm->submenu;
	}
	popup_bad_end((void*)m->submenu);
	m->submenu=NULL;
    }
    if (x>m->width || y<0 || y>m->height || (x<0 && !m->mainmenu))
	reselect(m, -1);
    else if (x<0 && m->mainmenu) {
	when_motion_window=m->mainmenu->win_id;
	XDestroyWindow(display, m->win_id);
	m=m->mainmenu;
	popup_bad_end((void*) m->submenu);
	m->submenu=NULL;
    } else if (y<m->th) {
	if (m->stickopt) reselect(m,TITLESEL);
	else reselect(m,-1);
    } else {
	int i=1,h;
	h=5+m->th+m->line[0].height;
	while (i<m->nr && h<y) h+=m->line[i++].height;
	i--;
	if (i!=m->selline) reselect(m,i);
	if (m->line[i].submenu &&
	    (x>m->width-trsize-8 || (!dragged && mouse_button==Button3))) {
	    MENU *sm;
	    m->line[i].submenu->x=m->x+m->width-trsize-8;
	    m->line[i].submenu->y=m->y+h-m->line[i].height;
	    m->line[i].submenu->transwin=m->transwin;
	    sm = popup_make(m->line[i].submenu);
	    m->submenu=sm;
	    sm->mainmenu=m;
	    when_motion_window = sm->win_id;
	}
    }
    dragged=True;
}

static void make_sticky(MENU *m)
{
    XSizeHints size_hints;
    XClassHint classhints;
    XWMHints wmhints;
    Atom rsatom[2],olatom,atatom;
    Window oldwin;

    wmhints=wm_hints;
    wmhints.flags = StateHint | InputHint | WindowGroupHint;
    wmhints.input = False;
    size_hints.flags = USPosition | USSize | PMinSize | PMaxSize;
    size_hints.min_height=size_hints.max_height=m->height;
    size_hints.min_width=size_hints.max_width=m->width;
    classhints.res_name = "popup";
    classhints.res_class = "MathEdit";
    XUnmapWindow(display, m->win_id);
    popup_mask = popup_mask ^ CWOverrideRedirect;
    oldwin=m->win_id;
    m->win_id = XCreateWindow(display,root_window,m->x,m->y,m->width,
			      m->height,2,CopyFromParent,InputOutput,
			      visual,
			      popup_mask, &popup_attr);
    rsatom[0] = XInternAtom(display, "_OL_DECOR_RESIZE", True);
    rsatom[1] = XInternAtom(display, "_OL_DECOR_HEADER", True);
    olatom = XInternAtom(display, "_OL_DECOR_DEL", True);
    atatom = XInternAtom(display, "ATOM", True);
    if (rsatom[0] && rsatom[1] && olatom) {
	XChangeProperty(display, m->win_id, olatom, atatom, 32,
			PropModeReplace, (void*) rsatom, 2);
    }
    XSetWMProperties(display, m->win_id, &wname, NULL, NULL, 0,
		     &size_hints, &wmhints, &classhints);
    set_protocols(m->win_id);
    XSetTransientForHint(display, m->win_id, m->transwin);
    XMapWindow(display, m->win_id);
    XDestroyWindow(display, oldwin);
    (void) remove_window(oldwin);
    if (!m->help) m->help=helpname[PINUPHELP];
    add_window(m->win_id, POPUPWINDOW, m->transwin, (void*) m,
	       m->help);
    popup_mask = popup_mask ^ CWOverrideRedirect;
    m->sticky=True;
}

static void popup_press(void *data, XButtonEvent *event)
{
    MENU *m = (MENU*) data;

    popup_motion(data, event->x, event->y);
    get_motion_hints(m->win_id,-1);
    dragged=False;
}

static void popup_release(void *data, XButtonEvent *event)
{
    MENU *m = (MENU*) data;
    Bool remove_it=True;
    /*
      select && submenu && !dragged && button==3 -> open_submenu()
      select && submenu && dragged  || button!=3 -> submenu_default_func()
      select && !submenu                         -> line_func()
      remove_none_sticky()
    */
    stop_motion_hints();
    if (m->selline>=0) {
	MENULINE *ml=m->line+m->selline;
	if (ml->submenu) {
	    if (dragged || mouse_button!=3) {
		MENU *sm=ml->submenu;
		while (sm->defline>=0 && sm->line[sm->defline].submenu)
		    sm = sm->line[sm->defline].submenu;
		if (sm->defline>=0) {
		    MENULINE *l;
		    l=sm->line+sm->defline;
		    if (l->func) (*(l->func))(l->fdata,l->fint);
		}
	    } else {
		remove_it=False;
	    }
	} else
	    if (ml->func) (*(ml->func))(ml->fdata,ml->fint);
    } else if (m->selline==TITLESEL) {
	if ((m->sticky= !m->sticky))
	    make_sticky(m);
    }
    if (remove_it) {
	/* remove popups (except the sticky one) */
	MENU *sm, *mh;
	sm=m;
	while (sm->submenu) sm=sm->submenu;
	while (sm) {
	    mh=sm->mainmenu;
	    sm->submenu=NULL;
	    if (sm->sticky) {
		sm->mainmenu=NULL;
		sm->selline=-1;
		popup_draw((void*)sm);
	    } else {
		XDestroyWindow(display, sm->win_id);
		popup_bad_end((void*)sm);
	    }
	    sm = mh;
	}
    }
}

static void popup_resize(void *data, XConfigureEvent *event)
{
    MENU *m = (MENU*) data;
    int change=(m->width!=event->width || m->height!=event->height);
    m->x=event->x;
    m->y=event->y;
    if (change) {
	m->width=event->width;
	m->height=event->height;
	popup_draw(data);
    }
}

FUNCTIONS popupfuncs = {
    popup_bad_end, popup_draw, popup_resize, popup_press, popup_release,
    popup_motion, NULL, NULL, NULL, NULL, popup_layout_change };

void popup_init(void)
{
    push_fontgroup(POPUPFONT);
    trsize=line_height()/3;
    pop_fontgroup();
    triangle[1].y=triangle[3].y=-trsize;
    trsize=trsize*2;
    triangle[1].x=-trsize;
    triangle[3].x=trsize;
    triangle[2].y=trsize;
    triangle[2].x=0;
    popup_mask = (CWBackPixel | CWBorderPixel | CWEventMask | CWColormap |
		  CWSaveUnder | CWOverrideRedirect);
    popup_attr.background_pixel = white_pixel;
    popup_attr.colormap = colormap;
    popup_attr.border_pixel = black_pixel;
    popup_attr.event_mask = (ExposureMask | ButtonPressMask |
			     ButtonReleaseMask | KeyPressMask |
			     ButtonMotionMask | PointerMotionHintMask |
			     OwnerGrabButtonMask | StructureNotifyMask |
			     VisibilityChangeMask );
    popup_attr.save_under = True;
    popup_attr.override_redirect = True;
    XStringListToTextProperty(&win_name, 1, &wname);
    XStringListToTextProperty(&win_name, 1, &iname);
}

void popup_remove(Window win)
{
    MENU *m;
    int i;
    i=0;
    while ((m = (MENU*) next_data_with_type(POPUPWINDOW, &i))) {
	if (m->transwin==win) {
	    if (m->mainmenu) {
		m->mainmenu->submenu=NULL;
		m->mainmenu=NULL;
	    }
	    if (m->submenu) {
		m->submenu->mainmenu=NULL;
		m->submenu=NULL;
	    }
	    XDestroyWindow(display, m->win_id);
	    popup_bad_end(m);
	} else
	    i++;
    }
}

void popup_unmap(Window win)
{
    MENU *m;
    int i;
    i=0;
    while ((m = (MENU*) next_data_with_type(POPUPWINDOW, &i))) {
	if (m->transwin==win)
	    XUnmapWindow(display, m->win_id);
	i++;
    }
}

void popup_map(Window win)
{
    MENU *m;
    int i;
    i=0;
    while ((m = (MENU*) next_data_with_type(POPUPWINDOW, &i))) {
	if (m->transwin==win)
	    XMapWindow(display, m->win_id);
	i++;
    }
}

MENU *popup_make(MENU *menu)
{
    int xp,yp,i,h;
    MENU *m;

    m = (MENU*) malloc(sizeof(MENU));
    *m = *menu;
    m->th=m->tw=0;
    m->mainmenu=NULL;
    m->submenu=NULL;
    xp=m->x;
    yp=m->y;
    if (xp==-1 && yp==-1) {
	Window root,child;
	int rx,ry;
	unsigned int buttons;
	(void) XQueryPointer(display, root_window, &root, &child,
			     &rx, &ry, &xp, &yp, &buttons);
    }
    m->win_id = *((Window*)test_window());
    popup_layout_change((void*) m);
    i=0;
    h=m->th;
    while (i<=m->defline) {
	h+=m->line[i].height;
	i++;
    }
    xp-=10;
    yp-=h;
    if (xp<0) xp=0;
    if (yp<0) yp=0;
    if (xp+m->width > display_width) xp=display_width - m->width;
    if (yp+m->height> display_height) yp=display_height - m->height;
    m->win_id = XCreateWindow(display, root_window, xp, yp, m->width,
			      m->height, 2, CopyFromParent, InputOutput,
			      visual,
			      popup_mask, &popup_attr);
    m->x=xp;m->y=yp;
    if (!m->help) m->help=helpname[PINUPHELP];
    add_window(m->win_id, POPUPWINDOW, m->transwin, (void*) m, m->help);
    XMapWindow(display, m->win_id);
    when_motion_window = m->win_id;
    return m;
}

