/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** qtype.h
**
** Qualified types: a type qualifier list, and a ctype.
*/

# ifndef QTYPEH
# define QTYPEH

abst_typedef /*@null@*/ struct _qtype
{
  ctype    type;
  qualList quals;
} *qtype;

/*@constant null qtype qtype_undefined;@*/
# define qtype_undefined ((qtype) NULL)

extern /*@truenull@*/ bool qtype_isUndefined (qtype q);
# define qtype_isUndefined(q) ((q) == qtype_undefined)

extern /*@falsenull@*/ bool qtype_isDefined (qtype q);
# define qtype_isDefined(q)   ((q) != qtype_undefined)

extern ctype qtype_getType (/*@sef@*/ qtype q);
# define qtype_getType(q) \
     (qtype_isDefined(q) ? (q)->type : ctype_unknown)

extern /*@exposed@*/ qualList qtype_getQuals (/*@sef@*/ qtype q);
# define qtype_getQuals(q) \
  (qtype_isDefined(q) ? (q)->quals : qualList_undefined)

extern void qtype_setType (/*@sef@*/ qtype q, ctype c);
# define qtype_setType(q, c) (qtype_isDefined(q) ? (q)->type = (c) : (c))

extern qtype qtype_addQualList (/*@returned@*/ qtype qt, qualList ql);
extern /*@notnull@*/ qtype qtype_create (ctype c) /*@*/ ;
extern /*@only@*/ qtype qtype_unknown(void) /*@*/ ;
extern qtype qtype_addQual (/*@returned@*/ qtype qt, qual q);
extern qtype qtype_combine (/*@returned@*/ qtype q1, ctype ct);
extern qtype qtype_mergeAlt (/*@returned@*/ qtype q1, /*@only@*/ qtype q2);
extern qtype qtype_mergeImplicitAlt (/*@returned@*/ qtype q1, /*@only@*/ qtype q2);
extern qtype qtype_resolve (/*@returned@*/ qtype q);
extern void qtype_adjustPointers (int n, /*@returned@*/ qtype q);
extern /*@only@*/ cstring qtype_unparse (qtype q) /*@*/ ;
extern qtype qtype_newBase (/*@returned@*/ qtype q, ctype ct);
extern qtype qtype_newQbase (/*@returned@*/ qtype q1, qtype q2);
extern /*@only@*/ qtype qtype_copy (qtype q);
extern void qtype_free (/*@only@*/ qtype q);

# else
# error "Multiple include"
# endif
