/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** intSet.h
**
** based on set_template.h
*/

# ifndef intSET_H
# define intSET_H

abst_typedef struct _intSet
{
  int entries;
  int nspace;
  /*@reldef@*/ /*@relnull@*/ int  *elements;
} *intSet;

/*@iter intSet_elements (sef intSet s, yield int el)@*/
# define intSet_elements(x, m_el) \
   { int m_ind; for (m_ind = 0 ; m_ind < (x)->entries; m_ind++) \
       { int m_el = (x)->elements[m_ind];  

# define end_intSet_elements }}

extern /*@only@*/ intSet intSet_new (void);

extern bool intSet_isEmpty (intSet s);
# define intSet_isEmpty(s) ((s)->entries == 0)

extern int intSet_size (intSet s);
# define intSet_size(s) ((s)->entries)

extern bool intSet_insert (intSet s, int el);
extern /*@unused@*/ bool intSet_member (intSet s, int el);
extern /*@only@*/ /*@unused@*/ cstring intSet_unparse (intSet s);
extern void intSet_free (/*@only@*/ intSet s);
extern /*@only@*/ cstring intSet_unparseText (intSet s);

/*@constant int intSetBASESIZE;@*/
# define intSetBASESIZE SMALLBASESIZE

# else
# error "Multiple include"
# endif



