/*
** filelocStack.h (from slist_templace.h)
*/

# ifndef filelocSTACK_H
# define filelocSTACK_H

abst_typedef /*@null@*/ struct _filelocStack
{
  int nelements;
  int free;
  /*@reldef@*/ /*@relnull@*/ o_fileloc *elements;
} *filelocStack ;

extern /*@falsenull@*/ bool filelocStack_isDefined (filelocStack f) /*@*/ ;

/*@constant null filelocStack filelocStack_undefined; @*/
# define filelocStack_undefined (NULL)
# define filelocStack_isDefined(f)   ((f) != filelocStack_undefined)

extern int filelocStack_size (/*@sef@*/ filelocStack s) /*@*/ ;
# define filelocStack_size(s)    (filelocStack_isDefined (s) ? (s)->nelements : 0)

extern int filelocStack_includeDepth (filelocStack s);
extern void filelocStack_printIncludes (filelocStack s) /*@modifies stderr@*/ ;

extern void filelocStack_clear (filelocStack s) /*@modifies s@*/ ;

extern /*@only@*/ filelocStack filelocStack_new (void) /*@*/ ;
extern /*@observer@*/ fileloc filelocStack_nextTop (filelocStack s) /*@*/ ;

extern bool
  filelocStack_popPushFile (filelocStack s, /*@only@*/ fileloc el) 
  /*@modifies s@*/ ;

extern /*@unused@*/ /*@only@*/ cstring filelocStack_unparse (filelocStack s) /*@*/ ;
extern void filelocStack_free (/*@only@*/ filelocStack s) ;

/*@constant int filelocStackBASESIZE;@*/
# define filelocStackBASESIZE MIDBASESIZE

# endif




