/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
# ifndef cstringSList_H
# define cstringSList_H

typedef /*@observer@*/ cstring ob_cstring;

abst_typedef /*@null@*/ struct _cstringSList
{
  int      nelements;
  int      nspace;
  /*@reldef@*/ /*@relnull@*/ ob_cstring *elements;
} *cstringSList ;

/*@constant null cstringSList cstringSList_undefined;@*/
# define cstringSList_undefined ((cstringSList) NULL)

extern /*@falsenull@*/ bool cstringSList_isDefined (cstringSList s) /*@*/ ;
# define cstringSList_isDefined(s)   ((s) != cstringSList_undefined)

extern int cstringSList_size (/*@sef@*/ cstringSList) /*@*/ ;
# define cstringSList_size(s) (cstringSList_isDefined (s) ? (s)->nelements : 0)

extern /*@falsenull@*/ bool cstringSList_empty (/*@sef@*/ cstringSList) /*@*/ ;
# define cstringSList_empty(s) (cstringSList_size(s) == 0)

extern /*@only@*/ cstringSList cstringSList_new (void) /*@*/ ;
extern cstringSList 
  cstringSList_add (/*@returned@*/ cstringSList s, /*@exposed@*/ cstring el) 
  /*@modifies s@*/ ;

extern void cstringSList_alphabetize (cstringSList s);

extern /*@only@*/ cstring cstringSList_unparseAbbrev (cstringSList s) /*@*/ ;
extern /*@unused@*/ /*@only@*/ cstring cstringSList_unparse (cstringSList s) ;
extern void cstringSList_free (/*@only@*/ cstringSList s) ;

extern void cstringSList_printSpaced (cstringSList s, int indent, int gap, int linelen);

/*@constant int cstringSListBASESIZE;@*/
# define cstringSListBASESIZE MIDBASESIZE

/*@iter cstringSList_elements (sef cstringSList x, yield exposed cstring el); @*/
# define cstringSList_elements(x, m_el) \
   { if (cstringSList_isDefined (x)) { \
       int m_ind; cstring *m_elements = &((x)->elements[0]); \
	 for (m_ind = 0 ; m_ind < (x)->nelements; m_ind++) \
	   { cstring m_el = *(m_elements++); 

# define end_cstringSList_elements }}}

# else
# error "Multiple include"
# endif




