/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** clauseStack.h
*/

# ifndef clauseStack_H
# define clauseStack_H

abst_typedef struct _clauseStack
{
  int nelements;
  int nspace;
  int current;
  /*@reldef@*/ clause *elements;
} *clauseStack ;

/*@iter clauseStack_elements (sef clauseStack s, yield clause el); @*/
# define clauseStack_elements(s, m_el) \
  { int m_i; for (m_i = (s)->nelements - 1; m_i >= 0; m_i--) { clause m_el = (s)->elements[m_i]; 

# define end_clauseStack_elements }} 

extern int clauseStack_size (clauseStack s) /*@*/ ;
extern bool clauseStack_isEmpty (clauseStack s) /*@*/ ;

# define clauseStack_size(s) ((s)->nelements)   
# define clauseStack_isEmpty(s) (clauseStack_size(s) == 0)

extern /*@only@*/ clauseStack clauseStack_new (void) /*@*/ ;

extern void clauseStack_push (clauseStack s, clause el) /*@modifies s@*/ ;
extern void clauseStack_pop (clauseStack s) /*@modifies s@*/ ;
extern clause clauseStack_top (clauseStack s) /*@*/ ;

extern /*@only@*/ cstring clauseStack_unparse (clauseStack s) /*@*/ ;
extern void clauseStack_free (/*@only@*/ clauseStack s) ;
extern void clauseStack_clear (clauseStack s) /*@modifies s@*/ ;
extern void clauseStack_switchTop (clauseStack s, clause x) /*@modifies s@*/ ;
extern void clauseStack_removeFirst (clauseStack s, clause key)
            /*@modifies s@*/ ;

extern int clauseStack_controlDepth (clauseStack s) /*@*/ ;

/*@constant int clauseStackBASESIZE;@*/
# define clauseStackBASESIZE MIDBASESIZE

# else
# error "Multiple include"
# endif




