;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime1.9/Read/reader.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Dec 27 11:16:00 1994                          */
;*    Last change :  Mon Apr  8 16:05:06 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Bigloo's reader                                                  */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __reader

   (import  (__error                   "Llib/error.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__structure               "Llib/struct.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__rgc                     "Rgc/runtime.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_numbers_6_5_flonum   "Ieee/flonum.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_ports_6_10_1         "Ieee/port.scm")
	    (__r4_input_6_10_2         "Ieee/input.scm")
	    (__r4_output_6_10_3        "Ieee/output.scm")
	    (__evenv                   "Eval/evenv.scm"))
   
   (foreign (macro obj beof             "BEOF")
	    (macro obj unspec           "BUNSPEC")
	    (macro obj make-cnst (long) "BCNST"))
   
   (export  *bigloo-interpreter*
	    (read . port)
	    (reader-reset!)))

;*---------------------------------------------------------------------*/
;*    *bigloo-interpreter* ...                                         */
;*---------------------------------------------------------------------*/
(define *bigloo-interpreter* #f)

;*---------------------------------------------------------------------*/
;*    Les variables de control du lecteur                              */
;*---------------------------------------------------------------------*/
(define *par-open* 0)
(define *bra-open* 0)

;*---------------------------------------------------------------------*/
;*    Two control variables.                                           */
;*---------------------------------------------------------------------*/
(define *position?*  #f)
(define *dot-symbol* (string->symbol ";"))

;*---------------------------------------------------------------------*/
;*    reader-reset! ...                                                */
;*---------------------------------------------------------------------*/
(define (reader-reset!)
   (set! *par-open* 0)
   (set! *bra-open* 0))

;*---------------------------------------------------------------------*/
;*    *std-grammar*                                                    */
;*---------------------------------------------------------------------*/
(define *std-grammar*
   (regular-grammar ((chiffre (>-< #\0 #\9))
		     (float   (! ((* chiffre) #\. (+ chiffre))
				 ((+ chiffre) #\. (* chiffre))))
		     (lettre  (>-< #\a #\z #\A #\Z #a128 #a255))
		     (special (in #\! #\@ #\~ #\$ #\%
				  #\^ #\& #\* #\> #\<
				  #\/ #\- #\_ #\+   
				  #\\ #\| #\= #\? #\: #\.))
		     (quote   (in #\" #\, #\' #\`))
		     (paren   (in #\( #\) #\[ #\] #\{ #\}))
		     (id      ((* chiffre)
			       (! lettre special)
			       (* (! lettre special chiffre #\, #\' #\`))))
		     (blank   (in #\space #\tab #\Newline)))
      
       ;; blank lines
      ((+ blank)
       (ignore))
      
       ;; comments
      ((";" (* (all)))
       (ignore))
      
       ;; the interpreter header
      (("#!" (* (all)))
       (set! *bigloo-interpreter* #t)
       (ignore))
      
       ;; characters
      ((#\# #\a (+ chiffre))
       (let ((string (the-string)))
	  (if (not (=fx (the-length) 5))
	      (error/location "read"
			      "Illegal ascii character"
			      string
			      (input-port-name    input-port)
			      (input-port-filepos input-port))
	      (integer->char (string->integer (substring string 2 5))))))
      ((#\# #\\ (! lettre chiffre special #\# quote paren ";" #\space))
       (string-ref (the-string) 2))
      ((#\# #\\ (lettre (+ lettre)))
       (let ((string    (the-string))
	     (char-name (string->symbol
			 (string-upcase
			  (substring (the-string) 2 (the-length))))))
	  (case char-name
	     ((newline)
	      #\Newline)
	     ((tab)
	      #\tab)
	     ((space)
	      #\space)
	     ((return)
	      (integer->char 13))
	     (else
	      (error/location "read"
			      "Illegal character"
			      string
			      (input-port-name    input-port)
			      (input-port-filepos input-port))))))

      ;; string
      ((#\" (* (! (out #\\ #\") (#\\ (all)))) #\")
       ;; string of chars
       (escape-scheme-string (the-small-string)))
      ((#\# #\" (* (! (out #\\ #\") (#\\ (all)))) #\")
       ;; foreign strings of char
       (escape-C-string (the-small-string)))

      ;; fixnum
      ((! (+ chiffre) (#\- (+ chiffre)) (#\+ (+ chiffre)))
       (the-fixnum))
      (("#o" (! (+ (>-< #\0 #\7)) ((in #\+ #\-) (>-< #\0 #\7))))
       (string->integer (substring (the-string) 2 (the-length)) 8))
      (("#d" (! (+ chiffre) ((in #\+ #\-) chiffre)))
       (string->integer (substring (the-string) 2 (the-length)) 10))
      (("#x" (! (+ (! chiffre (>-< #\a #\f) (>-< #\A #\F)))
		((in #\+ #\-) (+ (! chiffre (>-< #\a #\f) (>-< #\A #\F))))))
       (string->integer (substring (the-string) 2 (the-length)) 16))
      (("#e" (! (+ chiffre) ((in #\+ #\-) chiffre)))
       (string->elong (substring (the-string) 2 (the-length)) 10))
      (("#l" (! (+ chiffre) ((in #\+ #\-) chiffre))) 
       (string->llong (substring (the-string) 2 (the-length)) 10))

      ;; flonum
      ((! float
	  ((in #\+ #\-) float)
	  ((! float (+ chiffre)) (in #\e #\E) (+ chiffre))
	  ((in #\+ #\-) (! float (+ chiffre)) (in #\e #\E) (+ chiffre))
	  ((! float (+ chiffre)) (in #\e #\E) (in #\+ #\-) (+ chiffre))
	  ((in #\+ #\-)
	   (! float (+ chiffre)) (in #\e #\E) (in #\+ #\-) (+ chiffre)))
       (the-flonum))
      
      (pair (#\. (* blank) #\))
	    (error/location "read"
			    "Illegal pair"
			    (the-string)
			    (input-port-name    input-port)
			    (input-port-filepos input-port)))

      ;; doted pairs
      (pair (#\.)
	    *dot-symbol*)
      ((#\.)
       (error/location "read"
		       "Illegal token"
		       #\.
		       (input-port-name    input-port)
		       (input-port-filepos input-port)))

      ;; unspecified and eof-object
      ((#\# (! #\u #\e) (+ lettre))
       (let ((symbol (string->symbol
		      (string-upcase
		       (substring (the-string) 1 (the-length))))))
	  (case symbol
	     ((unspecified)
	      unspec)
	     ((eof-object)
	      beof)
	     (else
	      (error/location "read"
			      "Illegal identifier"
			      string
			      (input-port-name    input-port)
			      (input-port-filepos input-port))))))

      ;; booleans
      ((#\# (in #\t #\T))
       #t)
      ((#\# (in #\f #\F))
       #f)

      ;; constants
      (("#<" (+ (! chiffre (>-< #\a #\f #\A #\F))) ">")
       (let ((string (the-string)))
	  (if (not (=fx (the-length) 7))
	      (error/location "read"
			      "Illegal constant"
			      string
			      (input-port-name    input-port)
			      (input-port-filepos input-port))
	      (make-cnst (string->integer (substring (the-string) 2 6) 16)))))
      
       ;; identifier
      ((id)
       ;; this rule has to be placed after the rule matching the `.' char
       (the-symbol))

      ;; quotation
      ((#\')
       (cons 'quote (cons (ignore) '())))
      ((#\`)
       (cons 'quasiquote (cons (ignore) '())))
      ((#\,)
       (cons 'unquote (cons (ignore) '())))
      ((#\, #\@)
       (cons 'unquote-splicing (cons (ignore) '())))

      ;; lists
      ((in #\( #\[)
       (let ((open-key *par-open*)
	     (pos      (input-port-filepos input-port)))
	  (set! *par-open* (+fx 1 *par-open*))
	  (context 'pair)
	  (let loop-pair ((walk (ignore))
			  (pos  pos))
	     (cond
		((eq? walk *dot-symbol*)
		 ;; une pair pointee
		 (context)
		 (let ((cdr (ignore)))
		    (ignore)
		    (if (=fx open-key *par-open*)
			(begin
			   (context 'pair)
			   cdr)
			(error/location "read"
					"Illegal pair"
					cdr
					(input-port-name input-port)
					(input-port-filepos
					 input-port)))))
		((=fx open-key *par-open*)
		 (if (=fx open-key 0)
		     (context))
		 '())
		(else
		 (let ((new-pos (input-port-filepos input-port)))
		    (if *position?*
			;; we put position only on pairs.
			(econs walk
			       (loop-pair (ignore) new-pos)
			       (list 'at
				     (input-port-name input-port)
				     pos))
			(cons walk (loop-pair (ignore) new-pos)))))))))
      ((in #\) #\])
       (set! *par-open* (-fx *par-open* 1))
       (if (<fx *par-open* 0)
	   (begin
	      (set! *par-open* 0)
	      (ignore))
	   #f))

      ;; vectors
      ((#\# #\()
       (let ((open-key *par-open*))
	  (set! *par-open* (+fx 1 *par-open*))
	  (let loop-vector ((walk  (ignore))
			    (res  '())
			    (len   0))
	     (cond
		((=fx open-key *par-open*)
		 (let ((vect (c-create-vector len)))
		    (let loop-vector-inner ((i (-fx len 1))
					    (l res))
		       (if (=fx i -1)
			   vect
			   (begin
			      (vector-set! vect i (car l))
			      (loop-vector-inner (-fx i 1)
						 (cdr l)))))))
		(else
		 (loop-vector (ignore)
			      (cons walk res)
			      (+fx 1 len)))))))
      ((#\# chiffre chiffre chiffre #\()
       (let ((open-key *par-open*)
	     (tag      (string->integer (substring (the-string) 1 4))))
	  (set! *par-open* (+fx 1 *par-open*))
	  (let ((res (list->vector
		      (let loop-vector ((walk (ignore)))
			 (cond
			    ((=fx open-key *par-open*)
			     '())
			    (else
			     (cons walk (loop-vector (ignore)))))))))
	     (vector-tag-set! res tag)
	     res)))
      ((#\# id #\()
       (let ((id       (string->symbol (string-upcase (the-small-string))))
	     (open-key *par-open*))
	  (set! *par-open* (+fx 1 *par-open*))
	  (let ((l (let loop-tvector ((walk (ignore)))
		      (cond
			 ((=fx open-key *par-open*)
			  '())
			 (else
			  (cons walk (loop-tvector (ignore))))))))
	     (list->tvector id l))))

      ;; structures
      ((#\# #\{)
       (let ((open-key *bra-open*))
	  (set! *bra-open* (+fx 1 *bra-open*))
	  (cons '_structure_
		(let loop-struct ((walk (ignore)))
		   (cond
		      ((=fx open-key *bra-open*)
		       '())
		      (else
		       (cons walk (loop-struct (ignore)))))))))
      ((#\})
       (set! *bra-open* (-fx *bra-open* 1))
       (if (<fx *bra-open* 0)
	   (begin
	      (set! *bra-open* 0)
	      (ignore))
	   #f))

      ;; error
      (else
       (let ((char (the-failing-char)))
	  (if (eof-object? char)
	      (if (or (>fx *par-open* 0)
		      (>fx *bra-open* 0))
		  (begin
		     (reader-reset!)
		     (error "read"
			    "Unexpected end-of-file"
			    char))
		  (begin
		     (reset-eof input-port)
		     char))
	      (error/location "read"
			      "Illegal char"
			      (illegal-char-rep char)
			      (input-port-name    input-port)
			      (input-port-filepos input-port)))))))

;*---------------------------------------------------------------------*/
;*    read ...                                                         */
;*---------------------------------------------------------------------*/
(define (read . input-port)
   (set! *position?* #f)
   ;; read except an undocument argument used by the compiler to
   ;; get line number associated with expressions.
   (cond
      ((null? input-port)
       (read/rp *std-grammar* (current-input-port)))
      ((null? (cdr input-port))
       (read/rp *std-grammar* (car input-port)))
      (else
       (set! *position?* #t)
       (read/rp *std-grammar* (car input-port)))))
