;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime1.8/Llib/tstruct.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Mar 27 09:38:41 1995                          */
;*    Last change :  Wed Oct  4 15:59:10 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The typed vectors Scheme management.                             */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __tstructure

   (import  (__error                   "Llib/error.scm")
	    (__hash                    "Llib/hash.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__structure               "Llib/struct.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_output_6_10_3        "Ieee/output.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__evenv                   "Eval/evenv.scm"))

   (foreign (macro bool    c-tstruct?        (obj)         "TSTRUCTP")
	    (macro vector  c-tstruct->vector (tstruct)     "TSTRUCT_TO_VECTOR")
	    (macro symbol  c-tstruct-id      (tstruct)     "TSTRUCT_ID")
	    (macro tstruct allocate-tstruct  (obj obj obj) "ALLOCATE_TSTRUCT"))
	    
   (export  (inline tstruct?::bool          ::obj)
	    (inline tstruct-id::symbol      ::tstruct)
	    (inline tstruct->vector::vector ::tstruct))

   (pragma  (c-tstruct? (_type-checker_ tstruct) _no_side_effect_)
	    (tstruct? _no_side_effect_)))

;*---------------------------------------------------------------------*/
;*    tstruct? ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (tstruct? obj)
   (c-tstruct? obj))

;*---------------------------------------------------------------------*/
;*    tstruct-id ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (tstruct-id tstruct::tstruct)
   (c-tstruct-id tstruct))

;*---------------------------------------------------------------------*/
;*    tstruct->vector ...                                              */
;*---------------------------------------------------------------------*/
(define-inline (tstruct->vector::vector tstruct::tstruct)
   (c-tstruct->vector tstruct))
