;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime1.8/Ieee/flonum.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Nov 26 14:04:03 1992                          */
;*    Last change :  Fri Oct  6 14:29:35 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    6.5. Numbers (page 18, r4) The `flonum' functions                */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __r4_numbers_6_5_flonum

   (import  (__error                   "Llib/error.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    
	    (__evenv                   "Eval/evenv.scm"))

   (foreign (macro bool       c-flonum?   (obj)           "REALP")
	    (infix macro bool c-=fl       (double double) "==")
	    (infix macro bool c-<fl       (double double) "<")
	    (infix macro bool c-<=fl      (double double) "<=")
	    (infix macro bool c->fl       (double double) ">")
	    (infix macro bool c->=fl      (double double) ">=")
	    (infix macro double c-+fl     (double double) "+")
	    (infix macro double c--fl     (double double) "-")
	    (infix macro double c-*fl     (double double) "*")
	    (infix macro double c-/fl     (double double) "/")
	    (macro double       c-negfl   (double)        "NEG")
	    (macro double c-floor         (double)        "floor")
	    (macro double c-ceiling       (double)        "ceil")
	    (macro double c-exp           (double)        "exp")
	    (macro double c-log           (double)        "log")
	    (macro double c-sin           (double)        "sin")
	    (macro double c-cos           (double)        "cos")
	    (macro double c-tan           (double)        "tan")
	    (macro double c-asin          (double)        "asin")
	    (macro double c-acos          (double)        "acos")
	    (macro double c-atan          (double)        "atan")
	    (macro double c-atan2         (double double) "atan2")
	    (macro double c-sqrt          (double)        "sqrt")
	    (macro double c-pow           (double double) "pow")
	    (string       c-real->string  (double)        "real_to_string")
	    (macro double strtod          (string long)   "strtod"))
   
   (export  (inline real?::bool          ::obj)
	    (inline flonum?::bool        ::obj)
	    (inline =fl::bool            ::double ::double)
	    (inline >fl::bool            ::double ::double)
	    (inline >=fl::bool           ::double ::double)
	    (inline <fl::bool            ::double ::double)
	    (inline <=fl::bool           ::double ::double)
	    (inline zerofl?::bool        ::double)
	    (inline positivefl?::bool    ::double)
	    (inline negativefl?::bool    ::double)
	    (maxfl::double               ::double . rn)
	    (minfl::double               ::double . rn)
	    (inline max-2fl::double      ::double ::double)
	    (inline min-2fl::double      ::double ::double)
	    (inline +fl::double          ::double ::double)
	    (inline -fl::double          ::double ::double)
	    (inline *fl::double          ::double ::double)
	    (inline /fl::double          ::double ::double)
	    (inline negfl::double        ::double)
	    (inline absfl::double        ::double)
	    (inline floorfl::double      ::double)
	    (inline ceilingfl::double    ::double)
	    (inline truncatefl::double   ::double)
	    (inline roundfl::double      ::double)
	    (inline expfl::double        ::double)
	    (inline logfl::double        ::double)
	    (inline sinfl::double        ::double)
	    (inline cosfl::double        ::double)
	    (inline tanfl::double        ::double)
	    (inline asinfl::double       ::double)
	    (inline acosfl::double       ::double)
	    (atanfl::double              ::double . y)
	    (inline atan-1fl::double     ::double)
	    (inline atan-2fl::double     ::double ::double)
	    (inline atan-2fl-ur::double  ::double ::double)
	    (inline sqrtfl::double       ::double)
	    (inline sqrtfl-ur::double    ::double)
	    (inline exptfl::double       ::double ::double)
	    (inline string->real::double ::string)
	    (inline real->string::string ::double))

   (pragma  (c-flonum? (_type-checker_ real))
	    (real? _no_side_effect_)
	    (c-=fl _no_side_effect_)
	    (c->fl _no_side_effect_)
	    (c->=fl _no_side_effect_)
	    (c-<fl _no_side_effect_)
	    (c-<=fl _no_side_effect_)
	    (c-+fl _no_side_effect_)
	    (c--fl _no_side_effect_)
	    (c-*fl _no_side_effect_)
	    (c-/fl _no_side_effect_)
	    (c-negfl _no_side_effect_)
	    (c-exp _no_side_effect_)
	    (c-log _no_side_effect_)
	    (c-sin _no_side_effect_)
	    (c-cos _no_side_effect_)
	    (c-tan _no_side_effect_)
	    (c-asin _no_side_effect_)
	    (c-acos _no_side_effect_)
	    (c-atan _no_side_effect_)
	    (c-sqrt _no_side_effect_)))

;*---------------------------------------------------------------------*/
;*    real? ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (real? obj)
   (if (c-fixnum? obj)
       #t
       (c-flonum? obj)))

;*---------------------------------------------------------------------*/
;*    flonum? ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (flonum? obj)
   (c-flonum? obj))

;*---------------------------------------------------------------------*/
;*    =fl ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (=fl r1 r2)
   (c-=fl r1 r2))

;*---------------------------------------------------------------------*/
;*    <fl ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (<fl r1 r2)
   (c-<fl r1 r2))

;*---------------------------------------------------------------------*/
;*    >fl ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (>fl r1 r2)
   (c->fl r1 r2))

;*---------------------------------------------------------------------*/
;*    <=fl ...                                                         */
;*---------------------------------------------------------------------*/
(define-inline (<=fl r1 r2)
   (c-<=fl r1 r2))

;*---------------------------------------------------------------------*/
;*    >=fl ...                                                         */
;*---------------------------------------------------------------------*/
(define-inline (>=fl r1 r2)
   (c->=fl r1 r2))

;*---------------------------------------------------------------------*/
;*    zerofl? ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (zerofl? r)
   (=fl r 0.0))

;*---------------------------------------------------------------------*/
;*    positivefl? ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (positivefl? r)
   (>=fl r 0.0))

;*---------------------------------------------------------------------*/
;*    negativefl? ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (negativefl? r)
   (<fl r 0.0))

;*---------------------------------------------------------------------*/
;*    +fl ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (+fl r1 r2)
   (c-+fl r1 r2))
	    
;*---------------------------------------------------------------------*/
;*    -fl ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (-fl r1 r2)
   (c--fl r1 r2))

;*---------------------------------------------------------------------*/
;*    *fl ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (*fl r1 r2)
   (c-*fl r1 r2))

;*---------------------------------------------------------------------*/
;*    /fl ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (/fl r1 r2)
   (c-/fl r1 r2))

;*---------------------------------------------------------------------*/
;*    negfl ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (negfl r1)
   (c-negfl r1))
    
;*---------------------------------------------------------------------*/
;*    maxfl ...                                                        */
;*---------------------------------------------------------------------*/
(define (maxfl r1 . rn)
   (let loop ((max r1)
	      (rn  rn))
      (if (null? rn)
	  max
	  (if (>fl (car rn) max)
	      (loop (car rn) (cdr rn))
	      (loop max (cdr rn))))))

;*---------------------------------------------------------------------*/
;*    max-2fl ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (max-2fl r1 r2)
   (if (>fl r1 r2)
       r1
       r2))

;*---------------------------------------------------------------------*/
;*    min-2fl ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (min-2fl r1 r2)
   (if (>fl r1 r2)
       r2
       r1))
   
;*---------------------------------------------------------------------*/
;*    minfl ...                                                        */
;*---------------------------------------------------------------------*/
(define (minfl r1 . rn)
   (let loop ((min r1)
	      (rn  rn))
      (if (null? rn)
	  min
	  (if (<fl (car rn) min)
	      (loop (car rn) (cdr rn))
	      (loop min (cdr rn))))))
   
;*---------------------------------------------------------------------*/
;*    absfl ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (absfl r)
   (if (<fl r 0.0)
       (negfl r)
       r))

;*---------------------------------------------------------------------*/
;*    floorfl ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (floorfl r)
   (c-floor r))

;*---------------------------------------------------------------------*/
;*    ceilingfl ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (ceilingfl r)
   (c-ceiling r))

;*---------------------------------------------------------------------*/
;*    truncatefl ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (truncatefl r)
   (if (negativefl? r)
       (ceilingfl r)
       (floorfl r)))

;*---------------------------------------------------------------------*/
;*    roundfl ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (roundfl r)
   (floorfl (+fl r 0.5)))

;*---------------------------------------------------------------------*/
;*    expfl ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (expfl x)
   (c-exp x))

;*---------------------------------------------------------------------*/
;*    logfl ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (logfl x)
   (c-log x))
 
;*---------------------------------------------------------------------*/
;*    sinfl ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (sinfl x)
   (c-sin x))

;*---------------------------------------------------------------------*/
;*    cosfl ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (cosfl x)
   (c-cos x))

;*---------------------------------------------------------------------*/
;*    tanfl ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (tanfl x)
   (c-tan x))

;*---------------------------------------------------------------------*/
;*    asinfl ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (asinfl x)
   (c-asin x))

;*---------------------------------------------------------------------*/
;*    acosfl ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (acosfl x)
   (c-acos x))

;*---------------------------------------------------------------------*/
;*    atanfl ...                                                       */
;*---------------------------------------------------------------------*/
(define (atanfl x . y)
   (if (null? y)
       (c-atan x)
       (let ((y (car y)))
	  (atan-2fl x y))))

;*---------------------------------------------------------------------*/
;*    atan-1fl ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (atan-1fl x)
   (c-atan x))

;*---------------------------------------------------------------------*/
;*    atan-2fl ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (atan-2fl x y)
   (let ((t (if (=fl x 0.0)
		(=fl y 0.0)
		#f)))
      (if t
	  (error "atanfl" "Domain error" 0.0)
	  (c-atan2 x y))))

;*---------------------------------------------------------------------*/
;*    atan-2fl-ur ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (atan-2fl-ur x y)
   (c-atan2 x y))

;*---------------------------------------------------------------------*/
;*    sqrtfl ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (sqrtfl r)
   (if (<fl r 0.0)
       (error "sqrt" "Domain error" r)
       (c-sqrt r)))

;*---------------------------------------------------------------------*/
;*    sqrtfl-ur ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (sqrtfl-ur r)
   (c-sqrt r))

;*---------------------------------------------------------------------*/
;*    exptfl ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (exptfl r1 r2)
   (c-pow r1 r2))

;*---------------------------------------------------------------------*/
;*    string->real ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (string->real string)
   (strtod string 0))

;*---------------------------------------------------------------------*/
;*    real->string ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (real->string real)
   (c-real->string real))
