/*---------------------------------------------------------------------*/
/*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \    /  '                              */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome Send them to                                           */
/*        <Manuel.Serrano@inria.fr>                                    */
/*        Manuel Serrano                                               */
/*        INRIA -- Rocquencourt                                        */
/*        Domaine de Voluceau, BP 105                                  */
/*        78153 Le Chesnay Cedex                                       */
/*        France                                                       */
/*---------------------------------------------------------------------*/


/*=====================================================================*/
/*   Llib/unix.scm                                                     */
/*   Bigloo (v1.8)                                                     */
/*   Manuel Serrano (c)       Thu Apr 11 10:48:22 PDT 1996             */
/*=====================================================================*/
#define THE_GC BOEHM_GC
#include <bigloo.h>
#include <signal.h>

/* The C generated type (for typed structures) */
extern obj_t dirname___unix( obj_t );
DEFINE_STRING( string1125___unix, aux1304, "/", 1 );
extern obj_t string_to_bstring( char * );
extern obj_t getenv___unix( char * );
extern obj_t _get_signal_handler___unix_38( obj_t, obj_t );
static obj_t *__cnst;
extern obj_t _dirname___unix( obj_t, obj_t );
DEFINE_STRING( string1128___unix, aux1306, "Illegal signal", 14 );
extern obj_t _basename___unix( obj_t, obj_t );
static obj_t tvectors_declarations____unix_213();
DEFINE_STRING( string1129___unix, aux1307, "Wrong number of arguments", 25 );
extern obj_t initialization___unix();
extern obj_t initialization___error();
extern obj_t system___unix( char * );
extern obj_t _date___unix( obj_t );
extern obj_t get_signal_handler___unix_125( int );
extern obj_t basename___unix( obj_t );
DEFINE_STRING( string1124___unix, aux1309, "", 0 );
extern obj_t make_string( long, unsigned char );
extern obj_t chdir___unix( char * );
extern obj_t get_signal_handler( int );
DEFINE_STRING( string1126___unix, aux1310, ".", 1 );
extern obj_t command_line___unix_34();
DEFINE_STRING( string1127___unix, aux1311, "signal", 6 );
extern obj_t _signal___unix( obj_t, obj_t, obj_t );
extern char * date___unix();
extern obj_t c_signal( int, obj_t );
extern obj_t signal___unix( int, obj_t );
extern char * c_date();
extern obj_t _system___unix( obj_t, obj_t );
extern char * executable_name___unix_153();
extern obj_t _suffix___unix( obj_t, obj_t );
extern obj_t _executable_name___unix_22( obj_t );
extern obj_t _command_line___unix_68( obj_t );
extern obj_t _pwd___unix( obj_t );
static obj_t initialize_constants____unix_32();
extern obj_t prefix___unix( obj_t );
extern obj_t c_substring( obj_t, long, long );
static obj_t initialize_imported_modules____unix_31();
extern obj_t pwd___unix();
extern obj_t _getenv___unix( obj_t, obj_t );
extern char * executable_name;
extern obj_t command_line;
static obj_t require_initialization____unix_73 = BUNSPEC;
extern obj_t _prefix___unix( obj_t, obj_t );
extern obj_t suffix___unix( obj_t );
extern obj_t _chdir___unix( obj_t, obj_t );

DEFINE_EXPORT_PROCEDURE( get_signal_handler_env___unix_112, aux1313, _get_signal_handler___unix_38, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( dirname_env___unix_5, aux1314, _dirname___unix, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( pwd_env___unix_148, aux1316, _pwd___unix, 0L, 0 );
DEFINE_EXPORT_PROCEDURE( suffix_env___unix_183, aux1317, _suffix___unix, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( chdir_env___unix_153, aux1318, _chdir___unix, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( prefix_env___unix_42, aux1319, _prefix___unix, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( date_env___unix_24, aux1321, _date___unix, 0L, 0 );
DEFINE_EXPORT_PROCEDURE( signal_env___unix_17, aux1322, _signal___unix, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( getenv_env___unix_50, aux1323, _getenv___unix, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( command_line_env___unix_24, aux1324, _command_line___unix_68, 0L, 0 );
DEFINE_EXPORT_PROCEDURE( system_env___unix_222, aux1325, _system___unix, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( basename_env___unix_171, aux1326, _basename___unix, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( executable_name_env___unix_2, aux1329, _executable_name___unix_22, 0L, 0 );

obj_t initialization___unix()
{if(CBOOL(require_initialization____unix_73)){require_initialization____unix_73 = BFALSE;
initialize_imported_modules____unix_31();
tvectors_declarations____unix_213();
initialize_constants____unix_32();
require_initialization____unix_73 = BFALSE;
return BUNSPEC;
} else {return BUNSPEC;
}}

obj_t initialize_imported_modules____unix_31()
{initialization___error();
return BUNSPEC;
}

obj_t initialize_constants____unix_32()
{return BUNSPEC;
}

obj_t tvectors_declarations____unix_213()
{return BUNSPEC;
}

obj_t command_line___unix_34()
{return command_line;
}

obj_t _command_line___unix_68(obj_t env_945)
{return command_line___unix_34();
}

char * executable_name___unix_153()
{return executable_name;
}

obj_t _executable_name___unix_22(obj_t env_946)
{return string_to_bstring(executable_name___unix_153());
}

obj_t signal___unix(int num_659, obj_t proc_660)
{{bool_t test1268_1063;
{long aux1092_661;
aux1092_661 = PROCEDURE_ARITY(proc_660);
test1268_1063 = (aux1092_661==1);
}if(test1268_1063){bool_t test1274_1066;
if(((long)(num_659)<0))test1274_1066 = ((bool_t)1);
 else test1274_1066 = ((long)(num_659)>31);
if(test1274_1066){FAILURE(string1127___unix,string1128___unix,BINT(num_659));} else {return c_signal(num_659, proc_660);
}} else {FAILURE(string1127___unix,string1129___unix,proc_660);}}}

obj_t _signal___unix(obj_t env_947, obj_t num_948, obj_t proc_949)
{return signal___unix(CINT(num_948), proc_949);
}

obj_t get_signal_handler___unix_125(int num_662)
{return get_signal_handler(num_662);
}

obj_t _get_signal_handler___unix_38(obj_t env_950, obj_t num_951)
{return get_signal_handler___unix_125(CINT(num_951));
}

obj_t getenv___unix(char * string_663)
{if(getenv(string_663)){return string_to_bstring(getenv(string_663));
} else {return BFALSE;
}}

obj_t _getenv___unix(obj_t env_952, obj_t string_953)
{return getenv___unix(BSTRING_TO_STRING(string_953));
}

obj_t system___unix(char * string_664)
{return BINT(system(string_664));
}

obj_t _system___unix(obj_t env_954, obj_t string_955)
{return system___unix(BSTRING_TO_STRING(string_955));
}

char * date___unix()
{return c_date();
}

obj_t _date___unix(obj_t env_956)
{return string_to_bstring(date___unix());
}

obj_t chdir___unix(char * dirname_665)
{return BINT(chdir(dirname_665));
}

obj_t _chdir___unix(obj_t env_957, obj_t dirname_958)
{return chdir___unix(BSTRING_TO_STRING(dirname_958));
}

obj_t pwd___unix()
{{obj_t string_666;
{int k_870;
obj_t char_871;
k_870 = (int)(1000);
char_871 = BNIL;
if(NULLP(char_871)){string_666 = make_string((long)(k_870), ((unsigned char)' '));
} else {obj_t aux1010_872;
aux1010_872 = CAR(char_871);
string_666 = make_string((long)(k_870), (unsigned char)CCHAR(aux1010_872));
}}return string_to_bstring(getcwd(BSTRING_TO_STRING(string_666), (int)(1000)));
}}

obj_t _pwd___unix(obj_t env_959)
{return pwd___unix();
}

obj_t basename___unix(obj_t string_667)
{{long index_669;
{long aux1097_674;
aux1097_674 = (STRING_LENGTH(string_667)-1);
index_669 = aux1097_674;
loop_668:
if((index_669==-1)){return string_667;
} else {bool_t test1197_1019;
{unsigned char aux1093_670;
aux1093_670 = STRING_REF(string_667, index_669);
{unsigned char char2_882;
char2_882 = ((unsigned char)'/');
test1197_1019 = (aux1093_670==char2_882);
}}if(test1197_1019){long aux1094_671;
aux1094_671 = (index_669+1);
{long aux1095_672;
aux1095_672 = STRING_LENGTH(string_667);
return c_substring(string_667, aux1094_671, aux1095_672);
}} else {long aux1096_673;
aux1096_673 = (index_669-1);
{long index_1026;
index_1026 = aux1096_673;
index_669 = index_1026;
goto loop_668;
}}}}}}

obj_t _basename___unix(obj_t env_960, obj_t string_961)
{return basename___unix(string_961);
}

obj_t prefix___unix(obj_t string_676)
{{long len_677;
len_677 = (STRING_LENGTH(string_676)-1);
{long e_679;
long s_680;
e_679 = len_677;
s_680 = len_677;
loop_678:
if((s_680<=0)){long aux1103_681;
aux1103_681 = (1+e_679);
{long start_899;
start_899 = 0;
return c_substring(string_676, start_899, aux1103_681);
}} else {bool_t test1180_1001;
{bool_t test1181_1002;
{unsigned char aux1104_682;
aux1104_682 = STRING_REF(string_676, s_680);
test1181_1002 = (BCHAR(aux1104_682)==BCHAR(((unsigned char)'.')));
}if(test1181_1002)test1180_1001 = (e_679==len_677);
 else test1180_1001 = ((bool_t)0);
}if(test1180_1001){long aux1105_683;
aux1105_683 = (s_680-1);
{long aux1106_684;
aux1106_684 = (s_680-1);
{long s_1011;
long e_1010;
e_1010 = aux1105_683;
s_1011 = aux1106_684;
s_680 = s_1011;
e_679 = e_1010;
goto loop_678;
}}} else {long aux1110_685;
aux1110_685 = (s_680-1);
{long s_1013;
s_1013 = aux1110_685;
s_680 = s_1013;
goto loop_678;
}}}}}}

obj_t _prefix___unix(obj_t env_962, obj_t string_963)
{return prefix___unix(string_963);
}

obj_t dirname___unix(obj_t string_687)
{{long len_688;
len_688 = (STRING_LENGTH(string_687)-1);
{long read_690;
read_690 = len_688;
loop_689:
if((read_690<=0)){bool_t test1155_985;
{unsigned char aux1112_691;
aux1112_691 = STRING_REF(string_687, read_690);
{unsigned char char2_919;
char2_919 = ((unsigned char)'/');
test1155_985 = (aux1112_691==char2_919);
}}if(test1155_985){return string1125___unix;
} else {return string1126___unix;
}} else {bool_t test1158_988;
{unsigned char aux1113_692;
aux1113_692 = STRING_REF(string_687, read_690);
{unsigned char char2_923;
char2_923 = ((unsigned char)'/');
test1158_988 = (aux1113_692==char2_923);
}}if(test1158_988){long start_925;
start_925 = 0;
return c_substring(string_687, start_925, read_690);
} else {long aux1115_693;
aux1115_693 = (read_690-1);
{long read_993;
read_993 = aux1115_693;
read_690 = read_993;
goto loop_689;
}}}}}}

obj_t _dirname___unix(obj_t env_964, obj_t string_965)
{return dirname___unix(string_965);
}

obj_t suffix___unix(obj_t string_695)
{{long len_696;
len_696 = STRING_LENGTH(string_695);
{long read_698;
{long aux1121_702;
aux1121_702 = (len_696-1);
read_698 = aux1121_702;
loop_697:
if((read_698<0)){return string1124___unix;
} else {bool_t test1138_973;
{unsigned char aux1117_699;
aux1117_699 = STRING_REF(string_695, read_698);
{unsigned char char2_937;
char2_937 = ((unsigned char)'.');
test1138_973 = (aux1117_699==char2_937);
}}if(test1138_973){long aux1119_700;
aux1119_700 = (read_698+1);
return c_substring(string_695, aux1119_700, len_696);
} else {long aux1120_701;
aux1120_701 = (read_698-1);
{long read_979;
read_979 = aux1120_701;
read_698 = read_979;
goto loop_697;
}}}}}}}

obj_t _suffix___unix(obj_t env_966, obj_t string_967)
{return suffix___unix(string_967);
}

