;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/examples/Lower/lower.scm             */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Oct 19 14:49:54 1992                          */
;*    Last change :  Fri Aug 11 09:02:19 1995 (serrano)                */
;*                                                                     */
;*    Un petit programme qui prends un fichier `Lisp' et qui           */
;*    convertit tous les symboles en minuscule.                        */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(MODULE LOWER
   (MAIN MAIN))

;*---------------------------------------------------------------------*/
;*    main ...                                                         */
;*---------------------------------------------------------------------*/
(DEFINE (MAIN ARGV)
   (IF (NULL? (CDR ARGV))
       (BEGIN
	  (PRINT "usage: lower [file1] ... [filen]")
	  (exit -1))
       (FOR-EACH LOWERFILE (CDR ARGV))))

;*---------------------------------------------------------------------*/
;*    lowerfile ...                                                    */
;*---------------------------------------------------------------------*/
(DEFINE (LOWERFILE FILENAME)
   (let ((input-port  (open-INPUT-file filename))
	 (output-port (open-output-file (string-append filename "l"))))
      (cond
	 ((not (input-port? input-port))
	  (error "lower" "can't open input file" filename))
	 ((NOT (output-port? output-port))
	  (error "lower"
		 "can't open output file"
		 (string-append filename "l")))
	 (else
	  (lower input-port output-port)))))

;*---------------------------------------------------------------------*/
;*    lower ...                                                        */
;*---------------------------------------------------------------------*/
(define lower
   (let* ((par-open 0)
	  (grammar (regular-grammar ((chiffre (inside #\0 #\9))
				     (float   (or ((* chiffre) #\. (+ chiffre))
						 ((+ chiffre) #\. (* chiffre))))
				     (lettre  (inside #\a #\z #\A #\Z))
				     (special (in #\! #\@ #\# #\$ #\%
						  #\^ #\& #\* #\> #\<
						  #\/ #\. #\- #\_ #\+   
						  #\\ #\| #\{ #\= #\?
						  #\} #\: #\~))
				     (quote   (in #\" #\, #\' #\`))
				     (paren   (in #\( #\) #\[ #\]))
				     (blank   (in #\space #\tab #\newline))  
				     (id      (+  (or lettre chiffre special))))
		      ((blank)
		       (the-string))
		      ((#\# #\\ (! lettre
				   chiffre
				   special
				   quote
				   paren
				   ";"))
		       (the-string))
		      ((";" (* (all))) 
		       (the-string))
		      ((uncase "#\newline")
		       (the-string))
		      ((uncase "#\tab")
		       (the-string))
		      ((uncase "#\space")
		       (the-string))
		      ((#\" (* (! (outside #\")
				  (#\\ #\"))) #\")
		       (the-string))
		      ((eof (#\" (* (! (outside #\")
				       (#\\ #\")))))
		       (error "read" "Unexpected end-of-file" 'string))
		      ((or (+ chiffre)
			  (#\- (+ chiffre))
			  (#\+ (+ chiffre)))
		       (the-string))
		      (("#o" (or (+ (inside #\0 #\7))
				((in #\+ #\-)
				 (inside #\0 #\7))))
		       (the-string))
		      (("#d" (or (+ chiffre)
				((in #\+ #\-)
				 chiffre)))
		       (the-string))
		      (("#x" (or (+ (or chiffre
				      (inside #\a #\f)
				      (inside #\A #\F)))
				((in #\+ #\-)
				 (+ (or chiffre
				       (inside #\a #\f)
				       (inside #\A #\F))))))
		       (the-string))
		      ((or float
			  ((in #\+ #\-) float)
			  ((or float (+ chiffre))
			   (in #\e #\E) (+ chiffre)) 
			  ((in #\+ #\-) (or float (+ chiffre))
					(in #\e #\E) (+ chiffre))
			  ((or float (+ chiffre)) (in #\e #\E)
						 (in #\+ #\-) (+ chiffre))
			  ((in #\+ #\-) (or float (+ chiffre))
					(in #\e #\E) (in #\+ #\-) (+ chiffre)))
		       (the-string))
		      (pair (#\.)
			    (context)
			    'dot)
		      ((uncase "#t")
		       (the-string))
		      ((uncase "#f")
		       (the-string))
		      ((or id (#\. (+ #\.)))
		       (string-downcase (the-string)))
		      ((#\')
		       (cons 'quote (cons (ignore) '())))
		      ((#\`)
		       (cons 'quasiquote (cons (ignore) '())))
		      ((#\,)
		       (cons 'unquote (cons (ignore) '())))
		      ((#\, #\@)
		       (cons 'unquote-splicing (cons (ignore) '())))
		      ((in #\( #\[)
		       (let ((open-key par-open))
			  (set! par-open (+ 1 par-open))
			  (context 'pair)
			  (let loop-pair ((walk (ignore)))
			     (cond
				((= open-key par-open)
				 '())
				((eq? walk 'dot)
				 (let ((cdr (ignore)))
				    (ignore)
				    (if (= open-key par-open)
					cdr
					(begin
					   (error "read" "illegal pair" cdr)
					   (let loop ()
					      (if (= par-open open-key)
						  (ignore)
						  (begin
						     (ignore)
						     (loop))))))))
				(else
				 (cons walk (loop-pair (ignore))))))))
		      ((in #\) #\])
		       (set! par-open (- par-open 1))
		       (if (< par-open 0)
			   (begin
			      (set! par-open 0)
			      (ignore))
			   #f))
		      ((#\# #\()
		       (let ((car      (ignore)) 
			     (open-key par-open))
			  (set! par-open (+ 1 par-open))
			  (list->vector
			   (let loop-vector ((walk car))
			      (cond
				 ((= open-key par-open)
				  '())
				 (else
				  (cons walk
					(loop-vector (ignore)))))))))
		      (else
		       (let ((char (the-failing-char)))
			  (if (and (eof-object? char) (> par-open 0))
			      (error "read" "Unexpected end-of-file" char)
			      char))))))
      (lambda (input-port output-port)
	 (let loop ((sexp (read/rp grammar input-port)))
	    (if (eof-object? sexp)
		'done
		(begin
		   (display-sexp sexp output-port)
		   (loop (read/rp grammar input-port)))))))) 

;*---------------------------------------------------------------------*/
;*    display-sexp ...                                                 */
;*---------------------------------------------------------------------*/
(define (display-sexp sexp port)
   (cond
      ((pair? sexp)
       (cond
	  ((eq? (car sexp) 'quote)
	   (display "'" port)
	   (display (cadr sexp) port))
	  ((eq? (car sexp) 'unquote)
	   (display "," port)
	   (display (cadr sexp) port))
	  ((eq? (car sexp) 'quasiquote)
	   (display "`" port)
	   (display (cadr sexp) port))
	  ((eq? (car sexp) 'unquote-splicing)
	   (display ",@" port)
	   (display (cadr sexp) port))
	  (else
	   (let ((l sexp))
	      (display "(" port)
	      (for-each (lambda (exp) (display-sexp exp port))
			sexp)
	      (display ")" port)))))
      ((vector? sexp)
       (display "#(" port)
       (let loop ((i 0))
	  (if (= i (vector-length sexp))
	      (display "#)" port)
	      (begin
		 (display (vector-ref sexp i) port)
		 (loop (+ i 1))))))
      (else
       (display sexp port))))

	  
       
