;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Write/expanded.scm       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Dec 28 15:03:54 1994                          */
;*    Last change :  Tue Feb  6 18:05:14 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The pretty-print of expanded module.                             */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module write_expanded
   (include "Ast/ast.sch")
   (import  engine_param
	    main
	    write_scheme
	    tools_args
	    tools_file)
   (export  (write-expanded expanded)))

;*---------------------------------------------------------------------*/
;*    write-expanded ...                                               */
;*---------------------------------------------------------------------*/
(define (write-expanded expanded)
   (let* ((output-name (if (string? *dest*)
			   *dest*
			   (if (string? *src*)
			       (string-append (prefix *src*) ".escm")
			       #f)))
	  (port        (if (string? output-name)
			   (open-output-file output-name)
			   (current-output-port))))
      (if (not (output-port? port))
	  (error "write-expanded" "Can't open output file" output-name)
	  (let ((handler (lambda (escape proc mes obj)
			    (notify-error proc mes obj)
			    (close-output-port port)
			    (exit-bigloo -4))))
	     (try (begin
		     (set! *pp-case* 'lower)
		     (write-scheme-file-header port "The expanded module")
		     (write-scheme-comment port "The module clause")
		     (pp *module-clause* port)
		     (for-each (lambda (code)
				  (match-case code
				     ((define (?name . ?args) ?value)
				      (newline port)
				      (write-scheme-comment port name)
				      (pp code port))
				     ((define ?name ?value)
				      (newline port)
				      (write-scheme-comment port name)
				      (pp code port))
				     ((define-inline (?name . ?args) ?value)
				      (newline port)
				      (write-scheme-comment port name)
				      (pp code port))
				     (else
				      (write-scheme-comment port "")
				      (pp code port))))
			       expanded)
		     (close-output-port port))
		  handler)))))

