;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Write/ast.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Dec 31 07:29:03 1994                          */
;*    Last change :  Fri Feb  9 10:58:50 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The ast pretty-printer                                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module write_ast
   (include "Tools/pass.sch"
	    "Ast/ast.sch")
   (import  engine_param
	    main
	    write_scheme
	    ast_global
	    ast_local
	    ast_dump
	    type_pptype)
   (export  (write-ast ast)))

;*---------------------------------------------------------------------*/
;*    write-ast ...                                                    */
;*---------------------------------------------------------------------*/
(define (write-ast globals)
   (let* ((output-name (if (string? *dest*)
			   *dest*
			   (if (string? *src*)
			       (string-append (prefix *src*) ".ast")
			       #f)))
	  (port        (if (string? output-name)
			   (open-output-file output-name)
			   (current-output-port))))
      (if (not (output-port? port))
	  (error "write-ast" "Can't open output file" output-name)
	  (let ((handler (lambda (escape proc mes obj)
			    (notify-error proc mes obj)
			    (close-output-port port)
			    (exit-bigloo -8))))
	     (try (begin
		     (set! *pp-case* 'lower)
		     (write-scheme-file-header port
					       (string-append "The AST ("
							      *current-pass*
							      ")"))
		     (for-each
		      (lambda (global)
			 (let ((fun (global-value global)))
			    (write-scheme-comment port
						  (global-shape global))
			    (write-scheme-comment port
						  (function-type->string fun))
			    (pp `(,(if (eq? (global-class global) 'procedure)
				       'define
				       'define-inline)
				  (,(global-shape global)
				   ,@(map local-shape (function-args fun)))
				  ,(ast->sexp (function-body fun)))
				port)))
		      globals)
		     (close-output-port port))
		  handler)))))

