;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Type/env.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Dec 25 11:32:49 1994                          */
;*    Last change :  Fri Jan 26 12:28:47 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The global environment manipulation                              */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module type_env
   (include "Type/type.sch"
	    "Tools/trace.sch")
   (import  tools_shape
	    tools_error
	    engine_param
	    type_cache
	    type_tools)
   (export  (initialize-Tenv!)
	    (set-Tenv!           <Tenv>)
	    (get-Tenv)
	    (find-type           <symbol>)
	    (type-exists?        <symbol>)
	    (bind-type!          <symbol>)
	    (use-type!           <symbol>)
	    (declare-type!       <symbol> <string> <symbol>  <s-exp>)
	    (declare-aliastype!  <symbol> <string> <symbol>  <s-exp> <type>)
	    (declare-subtype!    <symbol> <string> <symbol*> <symbol> <s-exp>)
	    (for-each-type!      <procedure>)
	    (obj-type?           <type>)
	    (sub-obj-type?       <type>)
	    (check-types)))

;*---------------------------------------------------------------------*/
;*    uninitialized-types ...                                          */
;*---------------------------------------------------------------------*/
(define (uninitialized-types)
   (let ((uninit '()))
      (for-each-type! (lambda (t) 
			 (if (eq? (type-info t) 'uninitialized)
			     (set! uninit (cons t uninit)))))
      uninit))

;*---------------------------------------------------------------------*/
;*    check-types ...                                                  */
;*---------------------------------------------------------------------*/
(define (check-types)
   (let ((ut (uninitialized-types)))
      (if (null? ut)
	  #t
	  (error "check-types"
		 "These types are uninitialized"
		 (map shape ut)))))

;*---------------------------------------------------------------------*/
;*    *Tenv* ...                                                       */
;*    -------------------------------------------------------------    */
;*    The Global environment (for global variable definitions).        */
;*---------------------------------------------------------------------*/
(define *Tenv* 'the-global-environment)

;*---------------------------------------------------------------------*/
;*    get-hash-number ...                                              */
;*---------------------------------------------------------------------*/
(define (get-hash-number o)
   (string->0..2^x-1 (symbol->string o) 10))

;*---------------------------------------------------------------------*/
;*    set-Tenv! ...                                                    */
;*---------------------------------------------------------------------*/
(define (set-Tenv! Tenv)
   (set! *Tenv* Tenv)
   (struct-set! *Tenv* 2 get-hash-number)
   (struct-set! *Tenv* 3 type-id)
   (struct-set! *Tenv* 5 eq?))
		 
;*---------------------------------------------------------------------*/
;*    get-Tenv ...                                                     */
;*---------------------------------------------------------------------*/
(define (get-Tenv)
   (struct-set! *Tenv* 2 'get-hash-number)
   (struct-set! *Tenv* 3 'type-id)
   (struct-set! *Tenv* 5 'eq?)
   *Tenv*)

;*---------------------------------------------------------------------*/
;*    initialize-Tenv! ...                                             */
;*---------------------------------------------------------------------*/
(define (initialize-Tenv!)
   ;; the global environment
   (set! *Tenv* (make-hash-table 1024 get-hash-number type-id eq? 256)))

;*---------------------------------------------------------------------*/
;*    find-type ...                                                    */
;*---------------------------------------------------------------------*/
(define (find-type id)
   [assert check (id) (or (null? id) (symbol? id))]
   (cond
      ((null? id)
       id)
      (else
       (let ((type (get-hash id *Tenv*)))
	  (if (not (type? type))
	      (error "find-type" "Can't find type" id)
	      type)))))

;*---------------------------------------------------------------------*/
;*    type-exists? ...                                                 */
;*---------------------------------------------------------------------*/
(define (type-exists? id)
   [assert check (id) (symbol? id)]
   (let ((type (get-hash id *Tenv*)))
      (if (not (type? type))
	  #f
	  (not (eq? (type-info type) 'uninitialized)))))

;*---------------------------------------------------------------------*/
;*    bind-type! ...                                                   */
;*---------------------------------------------------------------------*/
(define (bind-type! id)
   [assert check (id) (symbol? id)]
   (let ((type (get-hash id *Tenv*)))
      (if (type? type)
	  (if (and (not *lib-mode*)
		   (not (eq? (type-info type) 'uninitialized)))
	      (user-error "bind-type!"
			  "Type redefinition"
			  (shape type))
	      (begin
		 ;; the type has already been allocated,
		 ;; we simply reset its info slot...
		 (type-info-set! type '())
		 ;; and we return it.
		 type))
	  (let ((new (make-type)))
	     (type-id-set!            new id)
	     ;; the default info value
	     (type-info-set!          new '())
	     ;; the default of a type is to denote mutable values
	     (type-mutable?-set!      new #t)
	     ;; and not to be a magic type
	     (type-magic?-set!        new #f)
	     ;; default `$'
	     (type-$-set!             new #f)
	     ;; default alias
	     (type-alias-set!         new #f)
	     ;; default pointed-to-by
	     (type-pointed-to-by-set! new #f)
	     (put-hash! new *Tenv*)
	     new))))

;*---------------------------------------------------------------------*/
;*    use-type! ...                                                    */
;*---------------------------------------------------------------------*/
(define (use-type! id)
   [assert check (id) (or (null? id) (symbol? id))]
   (cond
      ((null? id)
       id)
      (else
       (let ((type (get-hash id *Tenv*)))
	  (if (type? type)
	      type
	      (let ((type (bind-type! id)))
		 (type-info-set! type 'uninitialized)
		 type))))))

;*---------------------------------------------------------------------*/
;*    declare-type! ...                                                */
;*---------------------------------------------------------------------*/
(define (declare-type! id name class exp)
   [assert check (name) (string? name)]
   (let ((type (bind-type! id)))
      (type-name-set!  type name)
      (type-$-set!     type ($-in-name? name))
      (type-exp-set!   type exp)
      (type-class-set! type class)
      type))
 
;*---------------------------------------------------------------------*/
;*    declare-subtype! ...                                             */
;*    -------------------------------------------------------------    */
;*    Subtype inherit from coercion of their parents.                  */
;*---------------------------------------------------------------------*/
(define (declare-subtype! id name parents class exp)
   (trace (type loop) "declare-subtype: " id " " parents #\Newline)
   [assert check (parents) (list? parents)]
   [assert check (name) (string? name)]
   (let ((type    (bind-type! id))
	 (parents (map find-type parents)))
      (type-name-set! type name)
      (type-$-set!    type ($-in-name? name))
      (type-exp-set!  type exp)
      (type-class-set! type class)
      (type-parents-set! type parents)
      type))

;*---------------------------------------------------------------------*/
;*    declare-aliastype! ...                                           */
;*---------------------------------------------------------------------*/
(define (declare-aliastype! id name class exp alias)
   [assert check (alias) (type? alias)]
   (let ((type (declare-type! id name class exp)))
      (type-alias-set! type alias)
      type)) 

;*---------------------------------------------------------------------*/
;*    for-each-type! ...                                               */
;*---------------------------------------------------------------------*/
(define (for-each-type! proc)
   (for-each-hash proc *Tenv*))

;*---------------------------------------------------------------------*/
;*    obj-type? ...                                                    */
;*---------------------------------------------------------------------*/
(define (obj-type? type)
   (eq? type *obj*))

;*---------------------------------------------------------------------*/
;*    sub-obj-type? ...                                                */
;*    -------------------------------------------------------------    */
;*    Is a type a subtype of `obj' ?                                   */
;*---------------------------------------------------------------------*/
(define (sub-obj-type? type)
   (cond
      ((eq? type *obj*)
       #t)
      ((memq *obj* (type-parents type))
       #t)
      (else
       #f)))
