;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Reduce/cond.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jul 13 10:29:17 1995                          */
;*    Last change :  Wed Oct 11 11:42:37 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The conditional reduction                                        */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module reduce_conditional
   (include "Ast/node.sch")
   (import  tools_shape
	    tools_speek
	    ast_dump
	    ast_env)
   (export  (reduce-conditional! globals)))

;*---------------------------------------------------------------------*/
;*    reduce-conditional! ...                                          */
;*---------------------------------------------------------------------*/
(define (reduce-conditional! globals)
   (verbose 2 "        conditional expressions" #\Newline)
   (for-each (lambda (global)
		(let* ((fun (global-value global))
		       (ast (function-body fun))) 
		   (function-body-set! fun (ast-cond! ast))
		   #unspecified))
	     globals))

;*---------------------------------------------------------------------*/
;*    ast-cont! ...                                                    */
;*---------------------------------------------------------------------*/
(define (ast-cond! ast)
   (ast-case ast
      ((atom)
       ast)
      ((kwote)
       ast)
      ((var)
       ast)
      ((make-box)
       (make-box-value-set! ast (ast-cond! (make-box-value ast)))
       ast)
      ((box-ref)
       (box-ref-var-set! ast (ast-cond! (box-ref-var ast)))
       ast)
      ((box-set!)
       (box-set!-value-set! ast (ast-cond! (box-set!-value ast)))
       ast)
      ((prag-ma)
       (let loop ((exp (prag-ma-values ast)))
	  (if (null? exp)
	      ast
	      (begin
		 (set-car! exp (ast-cond! (car exp)))
		 (loop (cdr exp))))))
      ((fail)
       (fail-proc-set! ast (ast-cond! (fail-proc ast)))
       (fail-msg-set!  ast (ast-cond! (fail-msg ast)))
       (fail-obj-set!  ast (ast-cond! (fail-obj ast)))
       ast)
      ((sequence)
       (let loop ((exp (sequence-exp ast)))
	  (if (null? exp)
	      ast
	      (begin
		 (set-car! exp (ast-cond! (car exp)))
		 (loop (cdr exp))))))
      ((conditional)
       (conditional-test-set! ast (ast-cond! (conditional-test ast)))
       (conditional-then-set! ast (ast-cond! (conditional-then ast)))
       (conditional-else-set! ast (ast-cond! (conditional-else ast)))
       (let ((test (conditional-test ast)))
	  (ast-case test
	     ((atom)
	      (if (boolean? (atom-value test))
		  (if (atom-value test)
		      (conditional-then ast)
		      (conditional-else ast))))
	     (else
	      ast))))
      ((switch)
       (switch-test-set! ast (ast-cond! (switch-test ast)))
       (for-each (lambda (clause)
		    (set-cdr! clause (ast-cond! (cdr clause))))
		 (switch-clauses ast))
       ast)
      ((setq)
       (let ((var (var-variable (setq-var ast)))
	     (val (setq-val ast)))
	  (setq-val-set! ast (ast-cond! val)))
       ast)
      ((let-var)
       (for-each (lambda (binding)
		    (set-cdr! binding (ast-cond! (cdr binding))))
		 (let-var-bindings ast))
       (let-var-body-set! ast (ast-cond! (let-var-body ast)))
       ast)
      ((let-fun)
       (for-each (lambda (local)
		    (let ((fun (local-value local)))
		       (function-body-set! fun
					   (ast-cond! (function-body fun)))))
		 (let-fun-locals ast))
       (let-fun-body-set! ast (ast-cond! (let-fun-body ast)))
       ast)
      ((set-ex-it)
       (set-ex-it-body-set! ast (ast-cond! (set-ex-it-body ast)))
       ast)
      ((jump-ex-it)
       (jump-ex-it-exit-set! ast (ast-cond! (jump-ex-it-exit ast)))
       (jump-ex-it-value-set! ast (ast-cond! (jump-ex-it-value ast)))
       ast)
      ((fun)
       (fun-value-set! ast (ast-cond! (fun-value ast)))
       ast)
      ((app-ly)
       (app-ly-fun-set! ast (ast-cond! (app-ly-fun ast)))
       (app-ly-value-set! ast (ast-cond! (app-ly-value ast)))
       ast)
      ((funcall)
       (funcall-fun-set! ast (ast-cond! (funcall-fun ast)))
       (let loop ((actuals (funcall-actuals ast)))
	  (if (null? actuals)
	      ast
	      (begin
		 (set-car! actuals (ast-cond! (car actuals)))
		 (loop (cdr actuals))))))
      ((app)
       (app-fun-set! ast (ast-cond! (app-fun ast)))
       (let loop ((actuals (app-actuals ast)))
	  (if (null? actuals)
	      ast
	      (begin
		 (set-car! actuals (ast-cond! (car actuals)))
		 (loop (cdr actuals))))))))
       


   





