;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Parse/type.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Dec 27 18:24:34 1994                          */
;*    Last change :  Wed Oct  4 11:58:38 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The type parsing                                                 */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module parse_type
   (include "Type/type.sch"
	    "Tools/trace.sch")
   (import  tools_error
	    type_env
	    type_coercion
	    tvector_declare
	    tstruct_declare)
   (export  parse-type))

;*---------------------------------------------------------------------*/
;*    parse-type ...                                                   */
;*---------------------------------------------------------------------*/
(define (parse-type type-clauses)
   (for-each parse-one-type type-clauses))

;*---------------------------------------------------------------------*/
;*    parse-one-type ...                                               */
;*    -------------------------------------------------------------    */
;*    Type clause could be like:                                       */
;*       . (obj "obj_t")                                               */
;*       . (subtype bint "obj_t" (obj))                                */
;*       . (coerce bint int () (bint->cint))                           */
;*       . (coerce obj bint (integer?) ())                             */
;*---------------------------------------------------------------------*/
(define (parse-one-type clause)
   (trace init "parse-one-type: " clause #\Newline)
   (match-case clause
      (((? symbol?) (? string?))
       ;; the simple type declaration
       (declare-type! (car clause) (cadr clause) 'bigloo '()))
      ((magic (? symbol?) (? string?))
       ;; a magic type
       (let ((type (declare-type! (car clause) (caddr clause) 'bigloo '())))
	  (type-magic?-set! type #t)
	  type))
      ((subtype (and (? symbol?) ?child) (and ?name (? string?))
		(and (? pair?) ?parent))
       (let loop ((walk parent))
	  (cond
	     ((null? walk)
	      (declare-subtype! child name parent 'bigloo '()))
	     ((not (symbol? (car parent)))
	      (user-error "Parse error" "Illegal type declaration" clause))
	     ((not (type? (find-type (car parent))))
	      (user-error "Subtype" "Unknow parent type" clause))
	     (else
	      (loop (cdr walk))))))
      ((tvector (and (? symbol?) ?id) ((and (? symbol?) ?item-type)))
       (declare-tvector-type! id item-type clause))
      ((tstruct (and (? symbol?) ?id) . ?slots)
       (let loop ((s slots))
	  (if (null? s)
	      (declare-tstruct-type! id slots clause)
	      (match-case (car s)
		 (((? symbol?) (? symbol?))
		  (loop (cdr s)))
		 (else
		  (user-error "tstruct" "Illegal tstruct clause" clause))))))
      ((coerce (and (? symbol?) ?from) (and (? symbol?) ?to)
	       ?check-op ?coerce-op)
       (let loop ((check-op check-op))
	  (cond
	     ((null? check-op)
	      'ok)
	     ((not (symbol? (car check-op)))
	      (user-error "Coercion" "Illegal clause" clause))
	     (else
	      (loop (cdr check-op)))))
       (let loop ((coerce-op coerce-op))
	  (cond
	     ((null? coerce-op)
	      'ok)
	     ((match-case (car coerce-op)
		 ((? symbol?) #f)
		 ((lambda (?-) . ?-) #f)
		 (else #t))
	      (user-error "Coercion" "Illegal clause" clause))
	     (else
	      (loop (cdr coerce-op)))))
       (let ((tfrom (find-type from))
	     (tto   (find-type to)))
	  (cond
	     ((not (type? tfrom))
	      (user-error "type coercion" "Unknow type" from))
	     ((not (type? tto))
	      (user-error "type coercion" "Unknow type" to))
	     (else
	      (add-coercion! tfrom tto check-op coerce-op)))))
      (else
       (user-error "Parse error" "Illegal type declaration" clause))))
       
