;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Parse/definition.scm     */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Dec 27 09:53:13 1994                          */
;*    Last change :  Fri Mar 22 11:36:19 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We parse definitions (and definition prototypes).                */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module parse_definition
   (import tools_error
	   tools_args)
   (export (parse-formal-ident      <exp>)
	   (parse-formal-last-ident <exp>)
	   (parse-definition        <proto>)))

;*---------------------------------------------------------------------*/
;*    parse-formal-ident ...                                           */
;*    -------------------------------------------------------------    */
;*    This function parse a ident and return a pair <id, type>.        */
;*---------------------------------------------------------------------*/
(define (parse-formal-ident ident)
   (match-case ident
      ((? symbol?)
       (parse-formal-symbol-ident ident))
      ((:: (and (? symbol?) ?name) (and (? symbol?) ?type))
       (cons name type))
      ((:: (and (? symbol?) ?type))
       (cons (string->symbol "") type))
      (else
       (user-error "parse-error" "Illegal ident" ident))))

;*---------------------------------------------------------------------*/
;*    parse-formal-last-ident ...                                      */
;*    -------------------------------------------------------------    */
;*    Same as above but devoted to last n-ary function argument.       */
;*---------------------------------------------------------------------*/
(define (parse-formal-last-ident ident)
   (let ((ident (parse-formal-ident ident)))
      (match-case ident
	 ((?id . obj)
	  ident)
	 ((?id)
	  (cons id 'obj))
	 ((and (? symbol?) ?id)
	  (cons id 'obj))
	 (else
	  (user-error "parse-error" "Illegal ident" ident)))))

;*---------------------------------------------------------------------*/
;*    parse-formal-symbol-ident ...                                    */
;*---------------------------------------------------------------------*/
(define (parse-formal-symbol-ident ident)
   (let* ((string (symbol->string ident))
	  (len    (string-length string)))
      (let loop ((walker     0)
		 (id-stop    0)
		 (type-start 0))
	 (cond
	    ((=fx walker len)
	     (cond
		((and (=fx id-stop 0)
		      (>fx type-start 0))
		 ;; this empty name variable can be usefull to declare
		 ;; prototype so it is legal.
		 (cons (string->symbol "")
		       (string->symbol (substring string type-start len))))
		((=fx id-stop 0)
		 (cons ident '()))
		((=fx type-start len)
		 ;; empty type are eroneous
		 (user-error "Parse error" "Illegal formal identifier" ident))
		(else
		 (cons (string->symbol
			(substring string 0 id-stop))
		       (string->symbol
			(substring string type-start len))))))
	    ((and (char=? (string-ref string walker) #\:)
		  (<fx walker (-fx len 1))
		  (char=? (string-ref string (+fx walker 1)) #\:))
	     (if (>fx type-start 0)
		 (user-error "Parse error" "Illegal formal identifier" ident)
		 (loop (+fx walker 2)
		       walker
		       (+fx walker 2))))
	    (else
	     (loop (+fx walker 1)
		   id-stop
		   type-start))))))
		   
;*---------------------------------------------------------------------*/
;*    parse-definition ...                                             */
;*---------------------------------------------------------------------*/
(define (parse-definition prototype)
   (match-case prototype
      ((inline ?- . ?-)
       (parse-function-prototype (cdr prototype) 'inline))
      ((?- . ?-)
       (parse-function-prototype prototype 'procedure))
      ((atom ?-)
       (parse-variable-prototype prototype))
      (else
       (user-error "Parse error" "Illegal prototype" prototype))))

;*---------------------------------------------------------------------*/
;*    parse-function-prototype ...                                     */
;*---------------------------------------------------------------------*/
(define (parse-function-prototype proto type)
   (cons type (map-on-args parse-formal-ident proto)))

;*---------------------------------------------------------------------*/
;*    parse-variable-prototype ...                                     */
;*---------------------------------------------------------------------*/
(define (parse-variable-prototype proto)
   (cons 'variable (parse-formal-ident proto)))








