;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Init/main.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 17 09:51:40 1993                          */
;*    Last change :  Tue Feb  6 18:00:35 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The main entry point.                                            */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module main
   (main main)
   (import init_setrc
	   init_parse-args
	   engine_engine
	   tools_trace)
   (export (exit-bigloo value)))

;*---------------------------------------------------------------------*/
;*    *exit-bigloo* ...                                                */
;*    -------------------------------------------------------------    */
;*    The default value of this variable is some kind of suicide       */
;*    value, an absolute emergency exit.                               */
;*---------------------------------------------------------------------*/
(define *exit-bigloo* (lambda (x) (exit x)))

;*---------------------------------------------------------------------*/
;*    main ...                                                         */
;*---------------------------------------------------------------------*/
(define (main argv)
   ;; Pour le moment il n'y a pas de error handler. Si une
   ;; erreur survient avant l'installation de celui-ci, on
   ;; quit bigloo
   (if (not (member "-q" argv)) (setup-default-values))
   (bind-exit (exit)
      (set! *exit-bigloo* exit)
      (unwind-protect
	 (if (parse-args argv)
	     (bigloo)
	     -1)
	 (stop-trace))))

;*---------------------------------------------------------------------*/
;*    exit-bigloo ...                                                  */
;*---------------------------------------------------------------------*/
(define (exit-bigloo value)
   (*exit-bigloo* value))

		       
