;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    .../project/bigloo/comptime1.8/Globalize/integration.scm         */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jan 26 17:10:12 1995                          */
;*    Last change :  Thu Apr 27 17:34:42 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The computation of the L property:                               */
;*                                                                     */
;*    L(f,g) stand for `f be integrated in g ?'                        */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module globalize_integration
   (include "Globalize/globalize.sch"
	    "Ast/node.sch"
	    "Tools/trace.sch")
   (import  tools_shape
	    ast_local
	    globalize_globalize
	    (union globalize_kapture))
   (export  (set-integration!)))

;*---------------------------------------------------------------------*/
;*    set-integration! ...                                             */
;*---------------------------------------------------------------------*/
(define (set-integration!)
   (trace (globalize loop) "set-integration!")
   ;; fist of all, we compute the transitive closure of `cfrom' for
   ;; all globalized function.
   (for-each set-cfrom*! *E*)
   (for-each set-cfrom*! *G1*)
   (trace (globalize loop)
	  "looping on: " (shape *E*) " " (shape *G1*)
	  #\Newline)
   ;; we can now compute the integration properties
   (let loop ((tg    *E*)    ;; the `true globalised'
	      (fg    *G1*)   ;; the `false globalised'
	      (round 0))
      (trace (loop globalize)
	     "  set-integration!    tg: " (shape tg) #\Newline
	     "                      fg: " (shape fg) #\Newline)
      ;; we mark tg locals
      (for-each (lambda (local)
		   (fun-Ginfo-mark-set! (local-info local) round))
		tg)
      (let ((new-tg (get-new-tg tg fg round)))
	 (trace (globalize loop) "     new-tg: " (shape new-tg) #\Newline)
	 (if (null? new-tg)
	     ;; we have reached the fix point
	     (set-integrators! tg fg round)
	     ;; we have not reached the fix point we keep going
	     (let ((new-fg (get-new-fg fg round)))
		(trace (globalize loop) "     new-fg: "
		       (shape new-fg) #\Newline)
		(loop (append new-tg tg)
		      new-fg
		      (+fx round 1)))))))

;*---------------------------------------------------------------------*/
;*    set-cfrom*! ...                                                  */
;*---------------------------------------------------------------------*/
(define (set-cfrom*! local)
   [assert check (local) (local? local)]
   (let ((info (local-info local)))
      (if (or (pair? (fun-Ginfo-cfrom* info))
	      (null? (fun-Ginfo-cfrom* info)))
	  (fun-Ginfo-cfrom* info)
	  (begin
	     ;; we mark the function as seen
	     (fun-Ginfo-cfrom*-set! info '())
	     (let loop ((cfrom      (fun-Ginfo-cfrom info))
			(cfrom*-set '())
			(global     #f))
		(cond
		   ((null? cfrom)
		    (let ((res (let ((u (union cfrom*-set)))
				  (if (global? global)
				      (cons global u)
				      u))))
		       (trace (loop globalize) "     cfrom*( "
			      (local-shape local) " ): " (shape res)
			      #\Newline)
		       (fun-Ginfo-cfrom*-set! info res)
		       res))
		   ((global? (car cfrom))
		    (loop (cdr cfrom)
			  cfrom*-set
			  (car cfrom)))
		   (else
		    (let ((cfrom* (set-cfrom*! (car cfrom))))
		       (if (and (pair? cfrom*) (global? (car cfrom*)))
			   (loop (cdr cfrom)
				 (cons (cons (car cfrom) (cdr cfrom*))
				       cfrom*-set)
				 (car cfrom*))
			   (loop (cdr cfrom)
				 (cons (cons (car cfrom) cfrom*)
				       cfrom*-set)
				 global))))))))))
;*                                                                     */
;* 		    (loop (cdr cfrom)                                  */
;* 			  (cons (cons (car cfrom) (set-cfrom*! (car cfrom)))                    */
;* 				cfrom*-set)                            */
;* 			  global))))))))                               */

;*---------------------------------------------------------------------*/
;*    get-new-tg ...                                                   */
;*    -------------------------------------------------------------    */
;*    Each functions of `fg' which is called by two functions (or      */
;*    more) functions of `tg' goes into `tg'.                          */
;*---------------------------------------------------------------------*/
(define (get-new-tg tg fg round)
   (let loop ((new-tg '())
	      (fg     fg))
      (if (null? fg)
	  new-tg
	  (let ((local (car fg)))
	     (trace (loop globalize) "      get-new-tg: " (shape local)
		    " ... "
		    (shape (fun-Ginfo-cfrom* (local-info local)))
		    #\Newline)
	     (let liip ((cfrom (fun-Ginfo-cfrom* (local-info local)))
			(new   0))
		(cond
		   ((null? cfrom)
		    (if (<fx new 2)
			;; no, it is not a new one
			(loop new-tg (cdr fg))
			;; yes, it is a a new one
			(begin
			   (fun-Ginfo-mark-set! (local-info local)
						(-fx round 1))
			   (loop (cons local new-tg) (cdr fg)))))
		   ((global? (car cfrom))
		    (liip (cdr cfrom) (+fx new 1)))
		   ((or (not (fun-Ginfo-G? (local-info (car cfrom))))
			(<fx (fun-Ginfo-mark (local-info (car cfrom))) round))
		    ;; called by a non true globalised functions
		    (liip (cdr cfrom) new))
		   (else
		    (liip (cdr cfrom) (+fx new 1)))))))))

;*---------------------------------------------------------------------*/
;*    get-new-fg ...                                                   */
;*---------------------------------------------------------------------*/
(define (get-new-fg fg round)
   (let loop ((old-fg fg)
	      (new-fg '()))
      (cond
	 ((null? old-fg)
	  new-fg)
	 ((=fx (fun-Ginfo-mark (local-info (car old-fg))) (-fx round 1))
	  (loop (cdr old-fg) new-fg))
	 (else
	  (loop (cdr old-fg) (cons (car old-fg) new-fg))))))

;*---------------------------------------------------------------------*/
;*    set-integrators! ...                                             */
;*    -------------------------------------------------------------    */
;*    This function set the `integrator' field of non globalized       */
;*    functions.                                                       */
;*---------------------------------------------------------------------*/
(define (set-integrators! tg fg round)
   (trace (globalize loop) "set-integrators: " (shape tg)
	  " " (shape fg) " " (shape round) #\Newline)
   (let loop ((roots tg))
      (if (null? roots)
	  'done
	  (let liip ((roots     roots)
		     (new-roots '()))
	     (if (null? roots)
		 (loop new-roots)
		 (let ((root (car roots)))
		    (let laap ((cto  (fun-Ginfo-cto (local-info root)))
			       (new  new-roots))
		       (if (null? cto)
			   (liip (cdr roots) new)
			   (let* ((to   (car cto))
				  (info (local-info to)))
			      (cond
				 ((not (fun-Ginfo-G? info))
				  ;; not a globalized function. We skip it
				  (laap (cdr cto) new))
				 ((=fx (fun-Ginfo-mark info) round)
				  ;; this is a true globalized function,
				  ;; we skip it.
				  (laap (cdr cto) new))
				 ((local? (fun-Ginfo-integrator info))
				  ;; this function has its intergrator, we
				  ;; skip it.
				  (laap (cdr cto) new))
				 (else
				  ;; the function is no more globalized
				  ;; because it is integrated
				  (fun-Ginfo-G?-set! info #f)
				  (let ((integrator (get-integrator root)))
				     ;; we set its integrator
				     (fun-Ginfo-integrator-set! info
								integrator)
				     ;; we maintain the integrated list
				     (fun-Ginfo-integrated-set!
				      (local-info integrator)
				      (cons to (fun-Ginfo-integrated
						(local-info integrator)))))
				  (laap (cdr cto)
					(cons to new)))))))))))))

;*---------------------------------------------------------------------*/
;*    get-integrator ...                                               */
;*---------------------------------------------------------------------*/
(define (get-integrator local)
   (if (fun-Ginfo-G? (local-info local))
       local
       (fun-Ginfo-integrator (local-info local))))
				  

