;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Globalize/gloclo.scm     */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Feb  3 09:56:11 1995                          */
;*    Last change :  Fri Feb  9 11:00:39 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The global closure creation                                      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module globalize_global-closure
   (include "Tools/pass.sch"
	    "Tools/trace.sch"
	    "Ast/node.sch"
	    "Globalize/globalize.sch")
   (import  tools_shape
	    engine_param
	    globalize_ast
	    globalize_free
	    tools_args
	    type_cache
	    ast_sexp
	    ast_dump
	    ast_global
	    ast_local)
    (export (global-closure      <global> <loc>)
	    (make-global-closure <global>)))

;*---------------------------------------------------------------------*/
;*    global-closure ...                                               */
;*---------------------------------------------------------------------*/
(define (global-closure global loc)
   (the-global-closure global loc)
   (make-global-closure global))
      
;*---------------------------------------------------------------------*/
;*    make-global-closure ...                                          */
;*---------------------------------------------------------------------*/
(define (make-global-closure global)
   (let ((glo (global-info global)))
      (if (global? glo)
	  glo
	  (let* ((gloclo   (gloclo global))
		 (env      (make-local-variable 'env *procedure*))
		 (old-fun  (global-value global))
		 (new-fun  (make-function))
		 (new-args (map (lambda (old)
				   (let ((new (make-local-variable
					       (local-name old)
					       *obj*)))
				      (local-info-set! new
						       (default-var-Ginfo))
				      (var-Ginfo-kaptured?-set!
				       (local-info new) #f)
				      (local-access-set! new 'read)
				      new))
				(function-args old-fun))))
	     ;; we put several occurrence of the variable in order to
	     ;; be sure that it would not be remove by any optimisations.
	     (global-occurrence-set! gloclo 100)
	     ;; we must set now the info slot of env
	     (local-info-set! env (default-var-Ginfo))
	     (var-Ginfo-kaptured?-set! (local-info env) #f)
	     ;; we ajust the function definition
	     (function-inline?-set! new-fun #f)
	     (function-arity-set! new-fun (+-arity (function-arity old-fun) 1))
	     (function-args-set! new-fun (cons env new-args))
	     (function-escape?-set!  new-fun #t)
	     (function-type-res-set! new-fun *obj*)
	     (global-value-set! gloclo new-fun)
	     (function-body-set! new-fun
				 (ast-app #f
					  #f
					  #f
					  (ast-var #f #f #f global)
					  (map (lambda (v)
						  (ast-var #f #f #f v))
					       ;; we have to ignore the
					       ;; addition environment
					       ;; parameters, so
					       ;; we just take the cdr of the
					       ;; formals list.
					       new-args)
					  #f
					  #f
					  #f
					  #f))
	     (trace (globalize loop) "=======> J'ai cree le corps:"
		    (ast->sexp (function-body new-fun))
		    #\Newline)
	     gloclo))))
   
;*---------------------------------------------------------------------*/
;*    gloclo ...                                                       */
;*---------------------------------------------------------------------*/
(define (gloclo global)   
   (let ((gloclo (declare-global-procedure! (global-import global)
					    (global-module global)
					    'procedure
					    (list (list
						   (symbol-append
						    '_
						    (global-name global)))))))
      (global-info-set! global gloclo)
      (if (not (global? gloclo))
	  (internal-error "global-closure"
			  "Can't allocate global closure"
			  gloclo)
	  gloclo)))
