;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Cgen/main.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Mar 16 17:59:38 1995                          */
;*    Last change :  Fri Feb  9 12:52:33 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We produce a Bigloo's `main' function.                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cgen_main
   (include "Ast/ast.sch")
   (import  engine_param
	    tools_module
	    ast_global
	    ast_env
	    ast_sexp)
   (export  (make-bigloo-main)))

;*---------------------------------------------------------------------*/
;*    make-bigloo-main ...                                             */
;*---------------------------------------------------------------------*/
(define (make-bigloo-main)
   (let* ((bigloo-main (declare-global-procedure!
			 'export
			 ;; we create an unused dummy module
			 *module-name*
			 'procedure
			 '((bigloo_main) (argv))))
	  (user-main   (cond
			  ((string? *main*)
			   (string->symbol (string-upcase *main*)))
			  ((symbol? *main*)
			   *main*)
			  (else
			   #f)))
	  (main-body   (if (symbol? user-main)
			   `(begin
			       (,(module-init-name *module-name*))
			       (bigloo-exit (,user-main argv)))
			   `(bigloo-exit (,(module-init-name *module-name*)))))
	  (ast         (sexp->ast main-body
				  (function-args (global-value bigloo-main))
				  'bigloo-main
				  #f
				  'read)))
      (global-target-name-set! bigloo-main "bigloo_main")
      (function-body-set! (global-value bigloo-main) ast)
      bigloo-main))

   
