;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Cgen/ident.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Mar 16 18:57:56 1995                          */
;*    Last change :  Wed Aug 30 11:24:52 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The translation of Scheme identifier to C identifier             */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cgen_ident
   (include "Ast/ast.sch")
   (import  engine_param)
   (export  (global-id   <global>)
	    (local-id    <local>)
	    (variable-id <variable>)
	    (scheme-id->c-id string)))

;*---------------------------------------------------------------------*/
;*    variable-id ...                                                  */
;*---------------------------------------------------------------------*/
(define (variable-id variable)
   (if (local? variable)
       (local-id variable)
       (global-id variable)))

;*---------------------------------------------------------------------*/
;*    global-id ...                                                    */
;*---------------------------------------------------------------------*/
(define (global-id global)
   (if (string? (global-target-name global))
       (global-target-name global)
       (let* ((sname (string-append
		      (symbol->string (global-name global))
		      "_"
		      (symbol->string (global-module global))))
	      (name  (scheme-id->c-id sname)))
	  (global-target-name-set! global name)
	  name)))

;*---------------------------------------------------------------------*/
;*    local-id ...                                                     */
;*---------------------------------------------------------------------*/
(define (local-id local)
   (if (string? (local-target-name local))
       (local-target-name local)
       (let ((name (scheme-id->c-id
		    (string-append (symbol->string (local-name local))
				   "_"
				   (integer->string (local-key local))))))
	  (local-target-name-set! local name)
	  name)))

;*---------------------------------------------------------------------*/
;*    scheme-id->c-id ...                                              */
;*---------------------------------------------------------------------*/
(define (scheme-id->c-id string)
   (let* ((nstring (if (and (not (char-alphabetic? (string-ref string 0)))
			    (not (char=? (string-ref string 0) #\_)))
		       (string-append "_" string)
		       string))
	  (len     (string-length nstring))
	  (rg      #f)
	  (res     (make-string len)))
      (let loop ((i 0))
	 (if (=fx i len)
	     (remove__ (if rg
			   (string-append
			    (string-downcase res)
			    (string-append
			     "_"
			     (integer->string (string->0..255 string))))
			   (string-downcase res)))
	     (let ((c (string-ref nstring i)))
		(cond
		   ((or (and (char>=? c #\A)
			     (char<=? c #\Z))
			(and (char>=? c #\a)
			     (char<=? c #\z))
			(and (char>=? c #\0)
			     (char<=? c #\9))
			(char=? c #\_))
		    (string-set! res i (string-ref nstring i))
		    (loop (+fx i 1)))
		   (else
		    (set! rg #t)
		    (string-set! res i #\_) 
		    (loop (+fx i 1)))))))))

;*---------------------------------------------------------------------*/
;*    remove__ ...                                                     */
;*    -------------------------------------------------------------    */
;*    On some architecture (alpha and mips) __init has a special       */
;*    meaning, in order to prevent all this strange case, we change    */
;*    ident which start by __init.                                     */
;*---------------------------------------------------------------------*/
(define (remove__ string)
   (cond
      ((not (>=fx (string-length string) 6))
       string)
      ((not (char=? (string-ref string 0) #\_))
       string)
      ((not (char=? (string-ref string 1) #\_))
       string)
      ((and (not (char=? (string-ref string 2) #\i))
	    (not (char=? (string-ref string 2) #\f)))
       string)
      ((and (not (char=? (string-ref string 3) #\n))
	    (not (char=? (string-ref string 3) #\i)))
       string)
      ((and (not (char=? (string-ref string 4) #\i))
	    (not (char=? (string-ref string 4) #\n)))
       string)
      ((and (not (char=? (string-ref string 5) #\t))
	    (not (char=? (string-ref string 5) #\i)))
       string)
      ((not (char=? (string-ref string 6) #\_))
       string)
      (else
       (string-append "_n_o_f_u_c_k_i_n_g___init_or_fini" string))))
