;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Cforeign/array.scm       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jul  7 15:18:00 1995                          */
;*    Last change :  Thu Apr  4 10:37:19 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The installation of c arrays.                                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cforeign_install-c-array
   (include "Type/type.sch"
	    "Ast/ast.sch"
	    "Tools/trace.sch")
   (import  tools_error
	    tools_shape
	    parse_cforeign
	    parse_static-export
	    ast_env
	    engine_param
	    cforeign_type
	    type_coercion
	    type_tools
	    type_env)
   (export  (install-c-array-accessors!)
	    (add-c-array! a)))

;*---------------------------------------------------------------------*/
;*    install-c-array-accessors! ...                                   */
;*---------------------------------------------------------------------*/
(define (install-c-array-accessors!)
   (let loop ((l   (get-c-array-list))
	      (res '()))
      (if (null? l)
	  res
	  (loop (cdr l) (append (make-c-array-access (car l)) res)))))

;*---------------------------------------------------------------------*/
;*    make-c-array-access ...                                          */
;*    -------------------------------------------------------------    */
;*    We can't use the array type in the C definitions because         */
;*    it is illegal to write something like:                           */
;*                                                                     */
;*    char The_tab_char[ 10 ];                                         */
;*    ...                                                              */
;*    {                                                                */
;*        char aux[ 10 ];                                              */
;*                                                                     */
;*        aux = The_tab_char;                                          */
;*                                                                     */
;*        ...                                                          */
;*    }                                                                */
;*                                                                     */
;*    Hence, all introduced functions used the type `pointer to'       */
;*    (p-id) rather than the `array type'. And then, we produce code   */
;*    looks like:                                                      */
;*                                                                     */
;*    char The_tab_char[ 10 ];                                         */
;*    ...                                                              */
;*    {                                                                */
;*        char *aux;                                                   */
;*                                                                     */
;*        aux = The_tab_char;                                          */
;*                                                                     */
;*        ...                                                          */
;*    }                                                                */
;*---------------------------------------------------------------------*/
(define (make-c-array-access tinfo)
   (trace type
	  "make-c-array-struct: type: " (shape (vector-ref tinfo 0))
	  #\Newline
	  "                     item: " (shape (vector-ref tinfo 1))
	  #\Newline)
   (if (eq? (type-class (vector-ref tinfo 1)) 'c-struct)
       (make-c-array-struct-access tinfo)
       (make-c-array-regular-access tinfo)))

;*---------------------------------------------------------------------*/
;*    make-c-array-regular-access ...                                  */
;*---------------------------------------------------------------------*/
(define (make-c-array-regular-access tinfo)
   (trace type "make-c-array-regular-access: " (shape (vector-ref tinfo 0))
	  #\Newline)
   (let* ((type             (vector-ref tinfo 0))
	  (item-type        (vector-ref tinfo 1))
	  (item-type-id     (type-id item-type))
	  (item-type-id*    (symbol-append (type-id item-type) '*))
	  (item-type-name   (type-name item-type))
	  (pitem-type       (get-aliased-type type))
	  (pitem-type-id    (type-id pitem-type))
	  (pitem-type-name  (type-name pitem-type))
	  (bpitem-type-id   (symbol-append 'b pitem-type-id))
	  (type-id          (type-id type))
	  (type-name        (type-name type))
	  (type-name-sans-$ (string-sans-$ type-name))
	  (btype-id         (symbol-append 'b type-id)))
      
      ;; the user allocation form without initialization
      (define (make-id)
	 `(define-inline (,(symbol-append 'make- type-id ':: pitem-type-id))
	     (,(symbol-append 'pragma:: pitem-type-id)
	      ,(string-append "("
			      (string-sans-$ pitem-type-name) ")GC_MALLOC( "
			      "sizeof( " type-name-sans-$ " ) )"))))
      
      ;; the predicate
      (define (bid?)
	 `(define-inline (,(symbol-append btype-id '?::bool) o::obj)
	     (if (foreign? o)
		 (eq? (foreign-id o) ',bpitem-type-id)
		 #f)))

      ;; equality (using ==)
      (define (=id)
	 `(define-inline (,(symbol-append '= type-id '::bool)
			  ,(symbol-append 'o1:: pitem-type-id)
			  ,(symbol-append 'o2:: pitem-type-id))
	     (pragma::bool "($1 == $2)" o1 o2)))

      (define (getter*-and-setter*)
	 (let ((item-type-name (string-sans-$ item-type-name)))
	    (list
	     `(define-inline (,(symbol-append type-id '-ref:: item-type-id)
			      ,(symbol-append 'o:: pitem-type-id)
			      i::long)
		 (,(symbol-append 'c- pitem-type-id '-ref)
		  o
		  (pragma ,item-type-name)
		  i))
	     `(define-inline (,(symbol-append type-id '-set!::obj)
			      ,(symbol-append 'o:: pitem-type-id)
			      i::long
			      ,(symbol-append 'v:: item-type-id))
		 (,(symbol-append 'c- pitem-type-id '-set!)
		  o
		  (pragma ,item-type-name)
		  i
		  v)))))
      
      ;; in safe mode, the predicate bid? should not be removed
      ;; until type coercion. Then, we mark it as used with this
      ;; simili-hack
      (if (not *unsafe-type*)
	  (begin
	     (parse-static (list
			    `(inline ,(symbol-append btype-id '?::bool)
				     o::obj)))
	     (let ((btid? (find-global (symbol-append btype-id '?))))
		(global-import-set! btid? 'export)
		(global-occurrence-set! btid? 1000))))

      (cons* (make-id) (=id) (bid?) (getter*-and-setter*))))

;*---------------------------------------------------------------------*/
;*    make-c-array-struct-access ...                                   */
;*---------------------------------------------------------------------*/
(define (make-c-array-struct-access tinfo)
   (trace type "make-c-array-struct-access: " (shape (vector-ref tinfo 0))
	  #\Newline)
   (let* ((type             (vector-ref tinfo 0))
	  (item-type        (vector-ref tinfo 1))
	  (item-type-id     (type-id item-type))
	  (item-type-id*    (symbol-append (type-id item-type) '*))
	  (item-type-name   (type-name item-type))
	  (pitem-type       (get-aliased-type type))
	  (pitem-type-id    (type-id pitem-type))
	  (pitem-type-name  (type-name pitem-type))
	  (bpitem-type-id   (symbol-append 'b pitem-type-id))
	  (type-id          (type-id type))
	  (type-name        (type-name type))
	  (type-name-sans-$ (string-sans-$ type-name))
	  (btype-id         (symbol-append 'b type-id)))
      
      ;; the user allocation form without initialization
      (define (make-id)
	 `(define-inline (,(symbol-append 'make- type-id ':: pitem-type-id))
	     (,(symbol-append 'pragma:: pitem-type-id)
	      ,(string-append "("
			      (string-sans-$ pitem-type-name) ")GC_MALLOC( "
			      "sizeof( " type-name-sans-$ " ) )"))))
      
      ;; the predicate
      (define (bid?)
	 `(define-inline (,(symbol-append btype-id '?::bool) o::obj)
	     (if (foreign? o)
		 (eq? (foreign-id o) ',bpitem-type-id)
		 #f)))

      ;; equality (using ==)
      (define (=id)
	 `(define-inline (,(symbol-append '= type-id '::bool)
			  ,(symbol-append 'o1:: pitem-type-id)
			  ,(symbol-append 'o2:: pitem-type-id))
	     (pragma::bool "($1 == $2)" o1 o2)))

      (define (getter*-and-setter*)
	 (let ((item-type-name (string-sans-$ item-type-name)))
	    (list
	     `(define-inline (,(symbol-append type-id '-ref:: item-type-id*)
			      ,(symbol-append 'o:: pitem-type-id)
			      i::long)
		 (,(symbol-append 'pragma:: item-type-id*)
		  "&($1[ $2 ])" o i))
	     `(define-inline (,(symbol-append type-id '-set!::obj)
			      ,(symbol-append 'o:: pitem-type-id)
			      i::long
			      ,(symbol-append 'v:: item-type-id*))
		 (pragma "($1[ $2 ] = *($3), BUNSPEC)" o i v)))))
      
      ;; in safe mode, the predicate bid? should not be removed
      ;; until type coercion. Then, we mark it as used with this
      ;; simili-hack
      (if (not *unsafe-type*)
	  (begin
	     (parse-static (list
			    `(inline ,(symbol-append btype-id '?::bool)
				     o::obj)))
	     (let ((btid? (find-global (symbol-append btype-id '?))))
		(global-import-set! btid? 'export)
		(global-occurrence-set! btid? 1000))))

      (cons* (make-id) (=id) (bid?) (getter*-and-setter*))))

;*---------------------------------------------------------------------*/
;*    *c-array-list* ...                                               */
;*---------------------------------------------------------------------*/
(define *c-array-list* '())

;*---------------------------------------------------------------------*/
;*    add-c-array! ...                                                 */
;*---------------------------------------------------------------------*/
(define (add-c-array! s)
   (set! *c-array-list* (cons s *c-array-list*)))

;*---------------------------------------------------------------------*/
;*    get-c-array-list ...                                             */
;*---------------------------------------------------------------------*/
(define (get-c-array-list)
   (reverse! *c-array-list*))









   
