;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Cfa/special.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Apr  5 09:37:31 1995                          */
;*    Last change :  Fri Oct 27 10:21:39 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The allocation managment.                                        */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cfa_special
   (include "Tools/trace.sch"
	    "Ast/node.sch"
	    "Type/type.sch"
	    "Cfa/approx.sch")
   (import  tools_shape
	    cfa_cache
	    cfa_pair
	    cfa_procedure
	    cfa_vector
	    cfa_location
	    engine_param
	    ast_dump)
   (export  (is-special-call?      <ast>)
	    (closure->function     <ast>)
	    (is-alloc?             <ast>)
	    (create-special-approx <ast>)
	    (get-special-approx    <ast>)
	    (set-special-approx!   <ast> <approx>)
	    (start-cfa-special!)
	    (stop-cfa-special!)))

;*---------------------------------------------------------------------*/
;*    start-cfa-special! ...                                           */
;*---------------------------------------------------------------------*/
(define (start-cfa-special!)
   (start-cfa-procedure!)
   ;; procedure and pair optimizations are enable only in optimizing
   ;; mode (see cfa_procedure and cfa_pair modules).
   (start-cfa-vector!)
   (start-cfa-pair!)
   (start-cfa-location!)
   #t)

;*---------------------------------------------------------------------*/
;*    stop-cfa-special! ...                                            */
;*---------------------------------------------------------------------*/
(define (stop-cfa-special!)
   (stop-cfa-location!)
   (stop-cfa-pair!)
   (stop-cfa-procedure!)
   (stop-cfa-vector!)
   #t)

;*---------------------------------------------------------------------*/
;*    is-special-call? ...                                             */
;*---------------------------------------------------------------------*/
(define (is-special-call? ast)
   [assert check (ast) (or (funcall? ast) (app? ast))]
   (if (funcall? ast)
       #f
       (let ((fun (var-variable (app-fun ast))))
	  (cond
	     ((not (global? fun))
	      #f)
	     ((function? (global-value fun))
	      (ispecial? (function-cfa-info (global-value fun))))
	     ((ffunction? (global-value fun))
	      (ispecial? (ffunction-cfa-info (global-value fun))))
	     (else
	      #f)))))

;*---------------------------------------------------------------------*/
;*    closure->function ...                                            */
;*    -------------------------------------------------------------    */
;*    This function returns the function over which the closure        */
;*    is built.                                                        */
;*---------------------------------------------------------------------*/
(define (closure->function ast)
   [assert check (ast) (is-closure-alloc? ast)]
   (var-variable (car (app-actuals ast))))

;*---------------------------------------------------------------------*/
;*    is-alloc? ...                                                    */
;*---------------------------------------------------------------------*/
(define (is-alloc? ast)
   [assert check (ast) (ast? ast)]
   (if (not (app? ast))
       #f
       (let ((fun (var-variable (app-fun ast))))
	  (cond
	     ((not (global? fun))
	      #f)
	     ((function? (global-value fun))
	      (let ((val (global-value fun)))
		 (and (ispecial? (function-cfa-info val))
		      (ispecial-allocator? (function-cfa-info val)))))
	     (else
	      (let ((val (global-value fun)))
		 (and (ispecial? (ffunction-cfa-info val))
		      (ispecial-allocator? (ffunction-cfa-info val)))))))))

;*---------------------------------------------------------------------*/
;*    create-special-approx ...                                        */
;*---------------------------------------------------------------------*/
(define (create-special-approx ast)
   [assert check (ast) (app? ast)]
   (let* ((fun (var-variable (app-fun ast)))
	  (val (global-value fun)))
      (if (ffunction? val)
	  ((ispecial-make-iapprox (ffunction-cfa-info val)) ast)
	  ((ispecial-make-iapprox (function-cfa-info val)) ast))))

;*---------------------------------------------------------------------*/
;*    get-special-approx ...                                           */
;*---------------------------------------------------------------------*/
(define (get-special-approx ast)
   [assert check (ast) (app? ast)]
   (app-cfa-info-aux ast))

;*---------------------------------------------------------------------*/
;*    set-special-approx! ...                                          */
;*---------------------------------------------------------------------*/
(define (set-special-approx! ast approx)
   [assert check (ast) (ast? ast)]
   (app-cfa-info-aux-set! ast approx))
