;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Cfa/collect.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Apr  5 09:06:26 1995                          */
;*    Last change :  Wed Oct 11 11:15:25 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We collect all type and alloc approximations                     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cfa_collect
   (include "Tools/trace.sch"
	    "Ast/node.sch"
	    "Type/type.sch")
   (import  tools_shape
	    type_cache
	    engine_param
	    ast_dump
	    ast_sexp
	    ast_typeof
	    ast_env
	    cfa_special
	    cfa_closure
	    cfa_tvector
	    cfa_procedure
	    cfa_vector)
   (export  (collect-all-approx!)
	    (get-types)
	    (get-allocs)))

;*---------------------------------------------------------------------*/
;*    *cfa-mark* ...                                                   */
;*---------------------------------------------------------------------*/
(define *cfa-mark* #unspecified)

;*---------------------------------------------------------------------*/
;*    collect-all-approx! ...                                          */
;*---------------------------------------------------------------------*/
(define (collect-all-approx!)
   (trace (cfa loop init) "collect-approx!:" #\Newline)
   (set! *cfa-mark* (gensym 'cfa-mark))
   (use-type! *obj*)
   (use-type! *unspec*)
   (for-each-global!
    (lambda (global)
       (trace (cfa loop init) "      " (shape global) ": ")
       (cond
;*--- unused ----------------------------------------------------------*/
	  ((and (not (eq? (global-import global) 'export))
		(=fx (global-occurrence global) 0))
	   (trace (cfa loop init) "[unused]" #\Newline)
	   #unspecified)
;*--- variable --------------------------------------------------------*/
	  ((or (eq? (global-class global) 'variable)
	       (eq? (global-class global) 'c-variable)
	       (eq? (global-class global) 'c-macro-variable))
	   (trace (cfa loop init) "[variable]" #\Newline)
	   (use-type! (global-type global))
	   #unspecified)
;*--- sprocedure ------------------------------------------------------*/
	  ((eq? (global-class global) 'sprocedure)
	   (trace (cfa loop init) "[sprocedure]" #\Newline)
	   (use-type! (global-type global))
	   (let* ((val (global-value global))
		  (fun (closure->function val)))
	      (ast-collect! val)
	      (ast-collect! (function-body (global-value fun)))
	      #unspecified))
;*--- ffunction -------------------------------------------------------*/
	  ((or (eq? (global-class global) 'c-function)
	       (eq? (global-class global) 'c-macro-function))
	   (trace (cfa loop init) "[ffunction]" #\Newline)
	   (let ((val (global-value global)))
	      (use-type! (ffunction-type-res val))
	      (for-each use-type! (ffunction-type-args val))
	      #unspecified))
;*--- function --------------------------------------------------------*/
	  ((or (eq? (global-class global) 'procedure)
	       (eq? (global-class global) 'inline))
	   (trace (cfa loop init) "[function]" #\Newline)
	   (let ((val (global-value global)))
	      (use-type! (function-type-res val))
	      (for-each (lambda (l)
			   (use-type! (local-type l)))
			(function-args val))
	      (if (not (eq? (global-import global) 'import))
		  (ast-collect! (function-body val)))
	      #unspecified))
;*--- error -----------------------------------------------------------*/
	  (else
	   (internal-error "collect-approx!"
			   "Don't know what to do with"
			   (list (shape global)
				 (global-class global)
				 (global-import global)
				 (global-occurrence global)))))))
   (show-approx)
   #unspecified)

;*---------------------------------------------------------------------*/
;*    ast-collect! ...                                                 */
;*---------------------------------------------------------------------*/
(define (ast-collect! ast)
   (trace (cfa loop init) "ast-collect!: " (ast->sexp ast) #\Newline)
   (ast-case ast
      ((atom)
       (use-type! (typeof ast)))
      ((kwote)
       (kwote-collect! ast))
      ((var)
       #unspecified)
      ((fun)
       (internal-error "collect-approxmiations!"
		       "Illegal node found (fun node)"
		       (ast->sexp ast)))
      ((prag-ma)
       (for-each ast-collect! (prag-ma-values ast))
       (use-type! (typeof ast)))
      ((fail)
       (ast-collect! (fail-proc ast))
       (ast-collect! (fail-msg ast)) 
       (ast-collect! (fail-obj ast))
       (use-type! (typeof ast)))
      ((sequence)
       (for-each ast-collect! (sequence-exp ast)))
      ((conditional)
       (ast-collect! (conditional-test ast))
       (ast-collect! (conditional-then ast))
       (ast-collect! (conditional-else ast)))
      ((switch)
       (ast-collect! (switch-test ast))
       (for-each (lambda (clause)
		    (ast-collect! (cdr clause)))
		 (switch-clauses ast)))
      ((setq)
       (ast-collect! (setq-val ast))
       (use-type! (typeof ast)))
      ((let-var)
       (for-each (lambda (binding)
		    (use-type! (local-type (car binding)))
		    (ast-collect! (cdr binding)))
		 (let-var-bindings ast))
       ;; then, we type the body
       (ast-collect! (let-var-body ast)))
      ((let-fun)
       (for-each (lambda (l)
		    (let ((f (local-value l)))
		       (use-type! (function-type-res f))
		       (for-each (lambda (l)
				    (use-type! (local-type l)))
				 (function-args f))
		       (ast-collect! (function-body f))))
		 (let-fun-locals ast))
       (ast-collect! (let-fun-body ast)))
      ((set-ex-it)
       (use-type! (local-type (var-variable (set-ex-it-exit ast))))
       (ast-collect! (set-ex-it-body ast)))
      ((jump-ex-it)
       (ast-collect! (jump-ex-it-exit ast))
       (ast-collect! (jump-ex-it-value ast)))
      ((app-ly)
       (ast-collect! (app-ly-fun ast))
       (ast-collect! (app-ly-value ast)))
      ((funcall)
       (add-funcall! ast)
       (ast-collect! (funcall-fun ast))
       (for-each ast-collect! (funcall-actuals ast)))
      ((make-box)
       (use-type! *obj*)
       (ast-collect! (make-box-value ast)))
      ((box-ref)
       (use-type! *obj*)
       (ast-collect! (box-ref-var ast)))
      ((box-set!)
       (use-type! *obj*)
       (ast-collect! (box-set!-var ast))
       (ast-collect! (box-set!-value ast)))
      ((app)
       (for-each ast-collect! (app-actuals ast))
       (if (is-alloc? ast)
	   (begin
	      (use-alloc! ast)
	      (cond
		 ((is-closure-alloc? ast)
		  (add-closure! ast))
		 ((is-vector-alloc? ast)
		  (add-vector! ast))))))))

;*---------------------------------------------------------------------*/
;*    kwote-collect! ...                                               */
;*---------------------------------------------------------------------*/
(define (kwote-collect! ast)
   (use-type! (typeof ast))
   (let ((value (kwote-value ast)))
      (cond
	 ((and (>=fx *optim* 3) (vector? value))
	  (let ((dummy-ast (sexp->ast
			    (if (only-one-atomic-type? value)
				`(c-make-vector ,(vector-length value)
						,(vector-ref value 0))
				;; we can't optimize this vector
				;; so we create a dummy approximation
				;; that the compiler _can't_ optimizes
				`(c-make-vector ,(vector-length value)
						car))
			    '()
			    #f
			    #f
			    'read)))
	     (kwote-cfa-info-set! ast dummy-ast)
	     (ast-collect! dummy-ast)))
	 (else
	  (kwote-cfa-info-set! ast #f)))))

;*---------------------------------------------------------------------*/
;*    only-one-atomic-type? ...                                        */
;*    -------------------------------------------------------------    */
;*    Is a vector containing only one atomic type of values (e.g.      */
;*    integers, chars, reals, ...) ?                                   */
;*---------------------------------------------------------------------*/
(define (only-one-atomic-type? vector)
   (define (get-atype value)
      (cond
	 ((integer? value)
	  'integer)
	 ((char? value)
	  'char)
	 ((boolean? value)
	  'boolean)
	 ((string? value)
	  'string)
	 ((real? value)
	  'real)
	 (else
	  #f)))
   (let ((len (vector-length vector)))
      (if (=fx len 0)
	  #f
	  (let ((atype (get-atype (vector-ref vector 0))))
	     (let loop ((i 1))
		(cond
		   ((not atype)
		    #f)
		   ((=fx i len)
		    #t)
		   ((eq? (get-atype (vector-ref vector i)) atype)
		    (loop (+fx i 1)))
		   (else
		    #f)))))))
		    
;*---------------------------------------------------------------------*/
;*    *used-type* ...                                                  */
;*---------------------------------------------------------------------*/
(define *used-type* '())

;*---------------------------------------------------------------------*/
;*    use-type! ...                                                    */
;*---------------------------------------------------------------------*/
(define (use-type! type)
   (cond
      ((null? type)
       'done)
      ((eq? (type-info type) *cfa-mark*)
       'done)
      (else
       (type-info-set! type *cfa-mark*)
       (set! *used-type* (cons type *used-type*))
       'done)))

;*---------------------------------------------------------------------*/
;*    get-types ...                                                    */
;*---------------------------------------------------------------------*/
(define (get-types)
   *used-type*)

;*---------------------------------------------------------------------*/
;*    *used-alloc* ...                                                 */
;*---------------------------------------------------------------------*/
(define *used-alloc* '())

;*---------------------------------------------------------------------*/
;*    use-alloc! ...                                                   */
;*---------------------------------------------------------------------*/
(define (use-alloc! alloc)
   (set! *used-alloc* (cons alloc *used-alloc*)))

;*---------------------------------------------------------------------*/
;*    get-allocs ...                                                   */
;*---------------------------------------------------------------------*/
(define (get-allocs)
   *used-alloc*)

;*---------------------------------------------------------------------*/
;*    show-approx ...                                                  */
;*---------------------------------------------------------------------*/
(define (show-approx)
   (trace cfa "----------------------------------------" #\Newline
	  "Approximations: " #\Newline)
   (trace cfa "   type : ")
   (for-each (lambda (t)
		(trace cfa (shape t) " "))
	     *used-type*)
   (trace cfa #\Newline)
   (trace cfa "   alloc: ")
   (for-each (lambda (a)
		(trace cfa (ast->sexp a) " """))
	     *used-alloc*)
   (trace cfa #\Newline #\Newline))
