;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Cfa/cfa.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Feb 22 18:11:52 1995                          */
;*    Last change :  Tue Aug  8 10:48:56 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    THE control flow analysis engine                                 */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cfa_cfa
   (include "Ast/node.sch"
	    "Tools/trace.sch"
	    "Cfa/approx.sch"
	    "Type/type.sch")
   (import  ast_dump
	    ast_global
	    ast_env
	    type_cache
	    cfa_approx
	    cfa_app
	    cfa_funcall
	    cfa_cache
	    cfa_top
	    cfa_dead
	    cfa_closure
	    cfa_ast
	    tools_set
	    tools_shape)
   (export  (cfa!)
	    *cfa-stamp*
	    (continue-cfa!)))

;*---------------------------------------------------------------------*/
;*    The iteration process control                                    */
;*---------------------------------------------------------------------*/
(define *cfa-continue?* #unspecified)
(define *cfa-stamp*     -1)

;*---------------------------------------------------------------------*/
;*    continue-cfa! ...                                                */
;*---------------------------------------------------------------------*/
(define (continue-cfa!)
   (if (not *cfa-continue?*)
       (trace (cfa loop) "######## continue-cfa!" #\Newline))
   (set! *cfa-continue?* #t))

;*---------------------------------------------------------------------*/
;*    continue-cfa? ...                                                */
;*---------------------------------------------------------------------*/
(define (continue-cfa?)
   *cfa-continue?*)

;*---------------------------------------------------------------------*/
;*    stop-cfa! ...                                                    */
;*---------------------------------------------------------------------*/
(define (stop-cfa!)
   (set! *cfa-continue?* #f))
		    
;*---------------------------------------------------------------------*/
;*    cfa! ...                                                         */
;*---------------------------------------------------------------------*/
(define (cfa!)
   (trace cfa "Setting exported functions:" #\Newline)
   ;; we collect all the exported variables (both functions and
   ;; variables).
   (let ((glodefs '()))
      (for-each-global! (lambda (g)
			   (if (eq? (global-import g) 'export)
			       (set! glodefs (cons g glodefs)))))
      ;; and we start iterations
      (continue-cfa!)
      ;; and we do it
      (let loop ()
	 (if (continue-cfa?)
	     (begin
		(cfa-iterate! glodefs)
		(trace cfa "### iteration " *cfa-stamp* ": " #\Newline)
		(loop))))))

;*---------------------------------------------------------------------*/
;*    cfa-iterate! ...                                                 */
;*---------------------------------------------------------------------*/
(define (cfa-iterate! globals)
   (stop-cfa!)
   (set! *cfa-stamp* (+fx 1 *cfa-stamp*))
   (trace cfa #\Newline "====> Cfa iterate!: " *cfa-stamp* " <====" #\Newline)
   ;; starting by initialization can supress one iteration
   (spread-top! (cfa-fun-app! *initialization*))      
   (for-each (lambda (global)
		(trace cfa (shape global) ": " #\Newline)
		(case (global-class global)
		   ((procedure inline)
		    (spread-top! (cfa-fun-app! global)))
		   ((variable)
		    (spread-top! (get-approx global)))
		   ((sprocedure)
		    (spread-top! (cfa-ast! (global-value global))))
		   (else
		    (internal-error "cfa-iterate!"
				    "Unknown variable class"
				    (list (global-shape global)
					  (global-class global))))))
	     globals))




