;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Cfa/approx.sch           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Feb 21 16:12:20 1995                          */
;*    Last change :  Tue May  9 14:49:49 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The structure used in the approximation computation.             */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    approx ...                                                       */
;*---------------------------------------------------------------------*/
(define-struct approx
   type            ;; set     : the `typing' part of the approximation
   type-locked?    ;; bool    : are the type approximation locked ?
   alloc           ;; set     : the `allocation' part of the approximation
   top?            ;; bool    : is this approximation includes top ?
   top-locked?     ;; bool    : is this approxmiation can be topped ?
   stamp           ;; integer : a stamp
   exported?)      ;; bool    : is an approx exported (for allocations)

;*---------------------------------------------------------------------*/
;*    ifun ...                                                         */
;*---------------------------------------------------------------------*/
(define-struct ifun
   alive?          ;; bool    : is it a dead function ?
   stamp           ;; integer : a int to avoid multiple scan for iterations
   result-approx)  ;; approx  : the current possible result of this function.

;*---------------------------------------------------------------------*/
;*    ispecial ...                                                     */
;*    -------------------------------------------------------------    */
;*    Instances of this structure are stored in `function-info' slot   */
;*    and `ffunction-info' slot.                                       */
;*---------------------------------------------------------------------*/
(define-struct ispecial
   make-iapprox        ;; proc    : make the initial approx for this special
   allocator?          ;; bool    : is it an allocator ?
   spread-top!         ;; proc    : the way to propagate top in actuals
   spread-unstackable! ;; proc    : the propagation of non stackability
   app)                ;; proc    : what to do you encontering this special.
   
 
