;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Cfa/apply.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Apr  5 16:06:21 1995                          */
;*    Last change :  Thu Apr 13 16:09:37 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The apply management                                             */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cfa_apply
   (include "Tools/trace.sch"
	    "Ast/node.sch"
	    "Type/type.sch"
	    "Cfa/approx.sch")
   (import  cfa_approx
	    cfa_cache
	    cfa_app
	    cfa_top
	    cfa_ast
	    ast_dump
	    type_cache
	    tools_set
	    tools_shape)
   (export  (cfa-apply! <ast>)))

;*---------------------------------------------------------------------*/
;*    cfa-apply! ...                                                   */
;*    -------------------------------------------------------------    */
;*    We don't do any effort for apply.                                */
;*---------------------------------------------------------------------*/
(define (cfa-apply! ast)
   [assert check (ast) (approx? (get-approx ast))]
   (let* ((fun-A        (cfa-ast! (app-ly-fun ast)))
	  (fun-approx   (approx-alloc fun-A))
	  (value-approx (cfa-ast! (app-ly-value ast))))
      (trace (cfa loop)
	     "          cfa-funcall: " (ast->sexp ast) #\Newline
	     "                  fun: " (approx-shape fun-A) #\Newline
	     "                value: " (ast->sexp (app-ly-value ast))
	     #\Newline
	     "         value-approx: " (approx-shape value-approx)
	     #\Newline)
      (spread-top! fun-A)
      (spread-top! value-approx)
      (get-approx ast)))
	       
 
