;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Ast/dump.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Dec 31 07:26:21 1994                          */
;*    Last change :  Fri Dec  8 11:03:11 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The ast->sexp translator                                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module ast_dump
   (include "Ast/node.sch"
	    "Tools/trace.sch"
	    "Type/type.sch"
	    "Tvector/tvector.sch")
   (import  tools_error
	    tools_shape
	    tools_misc
	    tools_location
	    engine_param
	    parse_definition
	    type_env
	    ast_env
	    ast_global
	    ast_local)
   (export  (ast->sexp <ast>)))
 
;*---------------------------------------------------------------------*/
;*    ast->sexp ...                                                    */
;*---------------------------------------------------------------------*/
(define (ast->sexp ast)
   (try (do-ast->sexp ast)
	(lambda (escape proc mes obj)
	   (notify-error proc mes obj)
	   (flush-output-port (current-error-port))
	   (escape (list '***ERRROR obj)))))

;*---------------------------------------------------------------------*/
;*    do-ast->sexp ...                                                 */
;*---------------------------------------------------------------------*/
(define (do-ast->sexp ast)   
   (ast-case ast
      ((atom)
       (if (null? (atom-value ast))
	   ''()
	   (atom-value ast)))
      ((var)
       (let ((var (var-variable ast)))
	  (if (global? var)
	      (global-shape var)
	      (local-shape var))))
      ((kwote)
       (let ((value (kwote-value ast)))
	  (if (a-tvector? value)
	      `(quote ,(a-tvector (shape (a-tvector-type value))
				  (a-tvector-vector value)))
	      `(quote ,value))))
      ((sequence)
       `(begin ,@(map do-ast->sexp (sequence-exp ast))))
      ((setq)
       `(set! ,(do-ast->sexp (setq-var ast)) ,(do-ast->sexp (setq-val ast))))
      ((conditional)
       `(if ,(do-ast->sexp (conditional-test ast))
	    ,(do-ast->sexp (conditional-then ast))
	    ,(do-ast->sexp (conditional-else ast))))
      ((fail)
       `(failure ,(do-ast->sexp (fail-proc ast))
		 ,(do-ast->sexp (fail-msg ast))
		 ,(do-ast->sexp (fail-obj ast))))
      ((let-fun)
       `(labels ,(map (lambda (fun)
			 `(,(local-shape fun)
			   ,(map local-shape
				 (function-args
				  (local-value fun)))
			   ,(do-ast->sexp (function-body (local-value fun)))))
		      (let-fun-locals ast))
	   ,(do-ast->sexp (let-fun-body ast))))
      ((let-var)
       `(let ,(map (lambda (b)
		      `(,(local-shape (car b)) ,(do-ast->sexp (cdr b))))
		   (let-var-bindings ast))
	   ,(do-ast->sexp (let-var-body ast))))
      ((app-ly)
       `(apply ,(do-ast->sexp (app-ly-fun ast))
	       ,(do-ast->sexp (app-ly-value ast))))
      ((app)
       (cons (do-ast->sexp (app-fun ast))
	     (map do-ast->sexp (app-actuals ast))))
      ((funcall)
       `(,(case (funcall-strength ast)
	     ((extra-light)
	      'funcall-el)
	     ((light)
	      'funcall-l)
	     (else
	      'funcall))
	 ,(do-ast->sexp (funcall-fun ast))
	 ,@(map do-ast->sexp (funcall-actuals ast))))
      ((fun)
       `(function ,(do-ast->sexp (fun-value ast))))
      ((set-ex-it)
       `(set-ex-it (,(do-ast->sexp (set-ex-it-exit ast)))
		  ,(do-ast->sexp (set-ex-it-body ast))))
      ((jump-ex-it)
       `(jump-ex-it ,(do-ast->sexp (jump-ex-it-exit ast))
		   ,(do-ast->sexp (jump-ex-it-value ast))))
      ((switch)
       `(case ,(do-ast->sexp (switch-test ast))
	   ,@(map (lambda (clause)
		     (list (car clause)
			   (do-ast->sexp (cdr clause))))
		  (switch-clauses ast))))
      ((prag-ma)
       `(,(if *type-shape?*
	      (symbol-append 'pragma:: (type-id (ast-type ast)))
	      'pragma)
	 ,(prag-ma-string ast)
	 ,@(map do-ast->sexp (prag-ma-values ast))))
      ((make-box)
       `(make-cell ,(do-ast->sexp (make-box-value ast))))
      ((box-ref)
       `(cell-ref ,(do-ast->sexp (box-ref-var ast))))
      ((box-set!)
       `(cell-set! ,(do-ast->sexp (box-set!-var ast))
		   ,(do-ast->sexp (box-set!-value ast))))
      (else
       (error "ast->sexp" "Illegal node" (shape ast)))))





