#!	/bin/sh

. cd_functions.sh

EXCLUDE=" \
    $ALWAYS_EXCLUDE \
	$ARCHIVE/doc \
	$ARCHIVE/tools \
	$ARCHIVE/boot \
	$RELEASE/binary-i386 \
	$RELEASE/binary-all \
	$RELEASE/msdos-i386 \
	$RELEASE/msdos-all \
	$RELEASE/Packages \
	$RELEASE/Packages.gz \
	$ARCHIVE/contrib/binary-i386 \
	$ARCHIVE/contrib/msdos-i386 \
	$ARCHIVE/contrib/ms-dos \
	$ARCHIVE/contrib/binary-all \
	$ARCHIVE/contrib/msdos-all \
	$ARCHIVE/contrib/binary \
	$ARCHIVE/contrib/Packages \
	$ARCHIVE/contrib/Packages.gz \
	$ARCHIVE/non-free/binary-i386 \
	$ARCHIVE/non-free/binary-all \
	$ARCHIVE/non-free/msdos-i386 \
	$ARCHIVE/non-free/msdos-all \
	$ARCHIVE/non-free/binary \
	$ARCHIVE/non-free/Packages \
	$ARCHIVE/non-free/Packages.gz \
	$RELEASE/binary-i386 \
	$RELEASE/binary-all \
	$RELEASE/disks-i386 \
	$RELEASE/msdos-i386 \
	$RELEASE/msdos-all \
	$RELEASE/binary \
	$RELEASE/Packages \
	$RELEASE/Packages.gz"

for i in $EXCLUDE; do
	EXCLUDE_FLAGS="$EXCLUDE_FLAGS -x $i"
done

# Write .mkisofsrc
VOLI="Debian 1.3.1 Source"
cd_info > .mkisofsrc

todos < text/both/colophon.txt > $ARCHIVE/colophon.txt
todos < text/source-cd/README.txt > $ARCHIVE/README.txt

# -K is a kludge to add 16K to the end. This makes up for a Linux read-ahead
# problem that still exists as of 2.1.30 using the loop mount, and maybe off
# of CD as well.

mkisofs -K -a -r -T -v \
 $EXCLUDE_FLAGS \
 -o $TARGET/source.iso \
 $ARCHIVE

rm -f $ARCHIVE/colophon.txt $ARCHIVE/README.txt
