/* This file is part of
* ======================================================
* 
*           LyX, the High Level Word Processor 	 
*	    Copyright (C) 1995 Matthias Ettrich
*
*           This file is Copyleft (C) 1996
*           Lars Gullik Bjnnes
*
*======================================================*/

#include "config.h"
#include "forms.h"
#include "latex.h"
#include "file.h"
#include "lyx_cb.h"
#include "buffer.h"


extern FD_LaTeXOptions *fd_latex_options;


void LaTeXOptionsOK(FL_OBJECT *ob, long data)
{
	LaTeXOptionsApply(ob, data);
	LaTeXOptionsCancel(ob, data);
}

void LaTeXOptionsApply(FL_OBJECT *, long)
{
	if (bufferlist.current()->text) {
		if (fl_get_button(fd_latex_options->accents))
			bufferlist.current()->allowAccents = true;
		else
			bufferlist.current()->allowAccents = false;
	} else {
		if (fl_get_button(fd_latex_options->accents))
			lyxrc.allowAccents = true;
		else
			lyxrc.allowAccents = false;
	}
}

void LaTeXOptionsCancel(FL_OBJECT *, long)
{
	fl_hide_form(fd_latex_options->LaTeXOptions);
}
