.\" Man page for LyX.
.\" Use the following command to generate viewable man page
.\"
.\"  tbl lyx.5 | {nt}roff -man
.\"
.\"  ul | more -fsk to view
.\"
.\"
.TH LYX 1 "October 1996" "Version 0.10 BETA" "LyX 0.10 BETA"
.SH NAME
LyX \- A High Level Word Processor
.\"
.\" setup
.de Cr
.ie n (c)
.el \(co
..
.SH SYNOPSIS
\fBlyx\fR [ \fIcommand-line switches\fR] [\fIname.lyx ...\fR ]
.br
.SH DESCRIPTION
\fBLyX\fR is too complex to be described completely in the "man" page
format. Ask your system administrator for the location of the full
documentation either in native \fBLyX\fR or in postscript format.
If your system is properly configured, you can access it from within
\fBLyX\fR under the Help menu.

\fBLyX\fR is a modern approach of writing documents with a computer
which breaks with the tradition of the obsolete typewriter concept. It
is designed for people who wants a professional output with a minimum
of time effort, without becoming specialists in typesetting. Compared
to common word processors, \fBLyX\fR will increase the productivity a
lot, since most of the typesetting will be done by the computer, not
the author. With \fBLyX\fR the author can concentrate on the contents
of his writing, since the computer will take care about the look.

Technically this is done by the combination of the comfortable usage of
a word processor with the high quality of a real typesetting system.
\fBLyX\fR uses the most popular and in our opinion best typesetting
system available: \fBLaTeX\fR. It is used for a wide range of
documents, especially in science. It is for example difficult to find a
mathematics or computer science book that is not done with LaTeX. So
some people claim that its main purpose is mathematic typesetting. This
isn't true. It is as good for writing letters, articles or any kind of
book, and often much better than common word processors. What prevents
some people from using this powerful free system, which is available on
almost every computer system, is the difficult usage. With plain LaTeX
the author enters the wishes for typesetting as commands into the text.
There means no visual feedback whether things are OK or not. It is also
difficult to read these documents before they have been printed, so
online editing isn't easy. This is where \fBLyX\fR enters the game.

\fBLyX\fR proposes an almost WYSIWYG-view of the document. "Almost"
means that the line- and page-breaks are not displayed as they will be
in the printed document. But this isn't necessary, since \fBLyX\fR
helps you to write portable documents with the generic mark up concept.
With this concept, the typesetter (LaTeX) has enough information to
break your text in a very nice manner. So line- and page-breaks aren't
your problem anymore. This means thath you don't have to care about the
rest of the document, when you do changes at the beginning. Neither do
you need to do low-level formatting such as "large bold italic modern
font and a little space above and below", but rather you simply choose
a so-called "layout" or "style" or "environment" for each paragraph.
This also gives you complete reusability of your documents: without any
deeper changes you can print them with another paper size or in two
columns or with landscape orientation. Or just switch the main font
(maybe you don't want a serif-font for the online version of your
document in the WWW). Or just cut some paragraphs from an older
document (maybe from an article) and paste them in a new one (maybe a
letter): The look will always fit without any manual labour. Of course
you can also do some low-level formatting at your own risk, but the
usual way with \fBLyX\fR is to tell what the text is, not what it
should look like. In a sense \fBLyX\fR gives you WYSIWYM editing (What
You See Is What You \fBMean\fR).

Currently, \fBLyX\fR uses the XFORMS library as a toolkit. \fBLyX\fR
should run everywhere, where XFORMS runs. This is on all major Unix
platforms as well as PC platforms, including Sun, SGI, HP, DEC
Alpha/OSF, IBM RS6000, Convex, Cray, i386/Linux, Alpha/Linux,
i386/FreeBSD, i386/NetBSD, DecSystem(mips)/Ultrix and others.
.SH OPTIONS
\fBLyX\fR supports the following command-line switches:
.TP 6
.BI \-width " x"
the width of the main window in \fBLyX\fR.
.TP
.BI \-height " y"
the height of the main window in \fBLyX\fR.
.TP
.BI \-dbg " debug-level"
where debug-level is a sum of debugging options:
.br
    \fI1\fR generic debugging info when running \fBLyX\fR
.br
    \fI2\fR debugging info from starting and ending of \fBLyX\fR
.br
    \fI4\fR debugging info about handling of keybindings
.br
    \fI8\fR debugging info about handling of toolbar
.br
   \fI16\fR debugging info from the parser
.br
   \fI32\fR debugging info from the lyxrc file
.br
   \fI64\fR debugging info about keyboard maps
.br
\fI65535\fR all of the above
.TP
.BI \-Reverse
swaps foreground and background colors.
.TP
.BI \-Mono
runs \fBLyX\fR in black and white mode.
.TP
.BI \-FastSelection
uses a fast black and white drawing routine for selections. If you use
this, the switches BackgroundColor and SelectionColor are ignored.
.PP
The following options can be used to define the colors to use for
different things:
.TP
.BI \-MathColor " color"
.TP
.BI \-MathFrameColor " color"
.TP
.BI \-FootColor " color"
.TP
.BI \-FillColor " color"
.TP
.BI \-OnOffLineColor " color"
.TP
.BI \-LatexColor " color"
.TP
.BI \-NoteColor " color"
.TP
.BI \-LightedColor " color"
.TP
.BI \-BackgroundColor " color"
.TP
.BI \-SelectionColor " color"
.PP
Furthermore, \fBLyX\fR understands the following generic command line options from the
\fBForms Library\fR:
.TP 6
.BI \-display " host:display"
specifies the server to connect to.
.TP
.BI \-bw " borderwidth"
specifies the border width to use to built-in objects. 
.TP
.BI \-visual " visualName"
requests a visual by name such as TrueColor etc. By default the
.B Forms Library
always selects the visual that has the most depth.
.TP
.BI \-depth " depth"
requests a specific depth.
.TP
.BI \-debug " level"
generates some info about the state of the
.B XForms. 
where 
.I level
is an integer between 1-5 and controls the amount of
information to output. Depending on the options used
when the
.B Forms Library
was built, a level more than 3 might not be available.
.TP
.B \-sync
runs the application in synchronous mode with debug level set to 4. 
.TP
.B \-private
requests a private colormap for the application.
.TP
.B \-shared
requests a shared colormap even if the application needs more
colors than available. For those colors that can't be allocated
in the shared colormap, substitutions are made so the closest
matching color is used.
.TP
.B \-stdcmap
requests a standard colormap.
.TP
.B \-name " newname"
specifies the application name under which resources are to be
obtained, rather than the default executable file name. 
.SH ENVIRONMENT
.TP
.B LYX_DIR
specifies which system directory to use. This usually is
/usr/local/lib/lyx.
.SH FILES
.nf
.ta \w'\fILIBDIR\fR/chkconfig.ltx  'u
~/.lyxrc        Personal configuration file
\fILIBDIR\fR/system.lyxrc       System wide configuration file
\fILIBDIR\fR/chkconfig.ltx      Updates LyX if LaTeX config has changed
\fILIBDIR\fR/bind/      Keybindings
\fILIBDIR\fR/clipart/   Clipart pictures
\fILIBDIR\fR/doc/       Documentation in \fBLyX\fR format.
\fILIBDIR\fR/examples/  Example documents
\fILIBDIR\fR/kbd/       Keyboard mappings
\fILIBDIR\fR/layouts/   Layout descriptions
\fILIBDIR\fR/templates/ Templates for documents
\fILIBDIR\fR/tex/       Extra TeX files
\fILIBDIR\fR/CREDITS    Credits file
.Sp
.fi

.I LIBDIR
is the system directory. This is usually /usr/local/lib/lyx.
.SH SEE ALSO
latex(1), xforms(5)

Full documentation in either native \fBLyX\fR or postscript format.
.SH BUGS
There are probably still some bugs in \fBLyX\fR. Please report them to
lyx@via.ecp.fr with detailed info, including which version of \fBLyX\fR
you use.
.SH AUTHOR
Copyright
.Cr
1995, 1996 by Matthias Ettrich (ettrich@informatik.uni-tuebingen.de)
and the rest of the \fBLyX Team\fR (See Credits under the Help menu
item).
