static char rcsid[] = "$Id: sgi.c,v 1.1 1996/05/13 18:39:45 lim Exp lim $";

/*
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the Free
 *  Software Foundation; either version 2 of the License, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 *  more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 *  SGI Image File Plug-in.
 *  Copyright (C) 1996  W. Jonathan Lim  lim@cs.umass.edu
 *
 *  Note: This plug-in requires SGI header files and libraries to compile.
 *        Check the accompanying Makefile.
 *
 *  Both read and write are supported. The plug-in will read either grayscale,
 *  RGB color, or RGBA images. Two buffers will be created for RGBA images: one
 *  RGB and one grayscale representing the alpha channel. RGBA images may be
 *  written by associating a grayscale buffer representing the alpha channel
 *  with the RGB buffer to be saved.
 *
 *  Include the following line in .gimprc:
 *    file-plug-in sgi 011 "sgi" "sgi,rgb,rgba"
 *
 */



#include <stdlib.h>
#include <image.h>
#include "gimp.h"





/* Declare some local functions. */

static void load_image( char * );
static void save_image( char * );
static void item_cb( int, void *, void * );
static void ok_cb( int, void *, void * );
static void cancel_cb( int, void *, void * );



static char *prog_name;
static int dialog_ID;

short rbuf[8192]; 
short gbuf[8192]; 
short bbuf[8192]; 
short abuf[8192]; 





int main
( argc, argv )
  int argc;
  char *argv[];
{
  /* Save the program name so we can use it later in reporting errors. */

  prog_name = argv[0];

  /*
   *  Call 'gimp_init' to initialize this filter. 'gimp_init' makes sure that
   *  the filter was properly called and it opens pipes for reading and
   *  writing.
   *
   */

  if ( gimp_init( argc, argv ) ) {

    /*
     *  This is a file filter so all it needs to know about is loading and
     *  saving images. So we'll install handlers for those two messages.
     *
     */

    gimp_install_load_save_handlers( load_image, save_image );

    /*
     *  Run until something happens. That something could be getting a 'QUIT'
     *  message or getting a load or save message.
     *
     */

    gimp_main_loop( );
  }


  return 0;
}





static void load_image
( filename )
  char *filename;
{
  register IMAGE *iimage;
  register int x, y, yy, xsize, ysize, zsize;
  int grayscale, alpha = 0;
  unsigned char *buf;
  Image image, alpha_image;
  unsigned char *dest, *alpha_dest;



  if ( (buf = malloc( strlen( filename ) + 11 )) == NULL )
    gimp_quit( );

  sprintf( buf, "Loading %s:", filename );
  gimp_init_progress( buf );
  free( buf );

  if ( (iimage = iopen( filename, "r" )) == NULL ) {
    printf( "%s: can't open \"%s\"\n", prog_name, filename );
    gimp_quit( );
  }

  xsize = iimage->xsize;
  ysize = iimage->ysize;
  zsize = iimage->zsize;

  if ( zsize == 1 )
    grayscale = 1;
  else if ( zsize >= 3 )
    grayscale = 0;
  else {
    printf( "%s: can only handle 1-channel grayscale or 3/4-channel color\n",
            prog_name );
    gimp_quit( );
  }

  if ( zsize == 4 )
    alpha = 1;


  image = gimp_new_image( filename, xsize, ysize,
                          ( grayscale ) ? GRAY_IMAGE : RGB_IMAGE );
  dest  = gimp_image_data( image );

  if ( alpha ) {
    alpha_image = gimp_new_image( filename, xsize, ysize, GRAY_IMAGE );
    alpha_dest  = gimp_image_data( alpha_image );
  }

  for ( y = 0; y < ysize; y++ ) {
    yy = ysize - 1 - y;
    if ( grayscale ) {
      getrow( iimage, gbuf, yy, 0 );
      for ( x = 0; x < xsize; x++ )
        *dest++ = gbuf[x];
    }
    else {
      getrow( iimage, rbuf, yy, 0 );
      getrow( iimage, gbuf, yy, 1 );
      getrow( iimage, bbuf, yy, 2 );
      if ( alpha )
        getrow( iimage, abuf, yy, 3 );
      for ( x = 0; x < xsize; x++ ) {
        *dest++ = rbuf[x];
        *dest++ = gbuf[x];
        *dest++ = bbuf[x];
        if ( alpha )
          *alpha_dest++ = abuf[x];
      }
    }
      
    if ( (y % 5) == 0 )
      gimp_do_progress( y, ysize );
  }


  iclose( iimage );

  gimp_do_progress( 1, 1 );
  gimp_display_image( image );
  gimp_update_image( image );
  gimp_free_image( image );
  if ( alpha ) {
    gimp_display_image( alpha_image );
    gimp_update_image( alpha_image );
    gimp_free_image( alpha_image );
  }
  gimp_quit( );


  return;
}





static void save_image
( filename )
  char *filename;
{
  IMAGE *oimage;
  register int x, y, yy, xsize, ysize, zsize;
  int grayscale, dim;
  Image image, alpha_image;
  unsigned char *src, *alpha_src, *buf;

  int group_ID;
  int acbut_ID;
  int amenu_ID;
  int alpha = 0, alpha_ID;



  image = gimp_get_input_image( 0 );
  xsize = gimp_image_width( image );
  ysize = gimp_image_height( image );


  if ( gimp_image_type( image ) == RGB_IMAGE ) {
    dialog_ID = gimp_new_dialog( "SGI Save Options" );
    group_ID  = gimp_new_row_group( dialog_ID, DEFAULT, NORMAL, "" );
    acbut_ID  = gimp_new_check_button( dialog_ID, group_ID, "Alpha Channel" );
    amenu_ID  = gimp_new_image_menu( dialog_ID, group_ID,
                                     IMAGE_CONSTRAIN_RGB |
                                     IMAGE_CONSTRAIN_GRAY, "Alpha Image" );

    gimp_add_callback( dialog_ID, acbut_ID, item_cb, &alpha );
    gimp_add_callback( dialog_ID, amenu_ID, item_cb, &alpha_ID );
    gimp_add_callback( dialog_ID, gimp_ok_item_id( dialog_ID ), ok_cb, 0 );
    gimp_add_callback( dialog_ID, gimp_cancel_item_id( dialog_ID ), cancel_cb,
                       0 );

    if ( ! gimp_show_dialog( dialog_ID ) ) {
      gimp_quit( );
      return;
    }

    if ( alpha )
      alpha_image = gimp_get_input_image( alpha_ID );
  }
    

  if ( (buf = malloc( strlen( filename ) + 11 )) == NULL )
    gimp_quit( );

  sprintf( buf, "Saving %s:", filename );
  gimp_init_progress( buf );
  free( buf );

  switch ( gimp_image_type( image ) ) {
  case RGB_IMAGE:
    zsize = 3;
    if ( alpha )
      zsize++;
    grayscale = 0;
    dim = 3;
    break; 
  case GRAY_IMAGE:
    zsize = 1;
    grayscale = 1;
    dim = 2;
    break;
  case INDEXED_IMAGE:
    printf( "%s: can only handle 1-channel grayscale or 3-channel color\n",
            prog_name );
    gimp_quit( );
    break;
  default:
    gimp_quit( );
    break;
  }

  if ( (oimage = iopen( filename, "w", RLE( 1 ), dim, xsize, ysize, zsize ))
       == NULL ) {
    printf( "%s: can't open \"%s\"\n", prog_name, filename );
    gimp_quit( );
  }


  src = gimp_image_data( image );
  if ( alpha )
    alpha_src = gimp_image_data( alpha_image );

  for ( y = 0; y < ysize; y++ ) {
    yy = ysize - 1 - y;
    if ( grayscale ) {
      for ( x = 0; x < xsize; x++ )
        gbuf[x] = *src++;
      putrow( oimage, gbuf, yy, 0 );
    }
    else {
      for ( x = 0; x < xsize; x++ ) {
        rbuf[x] = *src++;
        gbuf[x] = *src++;
        bbuf[x] = *src++;
        if ( alpha )
          abuf[x] = *alpha_src++;
      }
      putrow( oimage, rbuf, yy, 0 );
      putrow( oimage, gbuf, yy, 1 );
      putrow( oimage, bbuf, yy, 2 );
      if ( alpha )
        putrow( oimage, abuf, yy, 3 );
    }

    if ( (y % 5) == 0 )
      gimp_do_progress( y, ysize );
  }


  iclose( oimage );

  gimp_do_progress( 1, 1 );
  gimp_free_image( image );
  if ( alpha )
    gimp_free_image( alpha_image );
  gimp_quit( );


  return;
}





static void item_cb
( item_ID, client_data, call_data )
  int item_ID;
  void *client_data;
  void *call_data;
{
  *((long *) client_data) = *((long *) call_data); 


  return;
}





static void ok_cb
( item_ID, client_data, call_data )
  int item_ID;
  void *client_data;
  void *call_data;
{
  gimp_close_dialog( dialog_ID, 1 );


  return;
}





static void cancel_cb
( item_ID, client_data, call_data )
  int item_ID;
  void *client_data;
  void *call_data;
{
  gimp_close_dialog( dialog_ID, 0 );


  return;
}
