
/* stretch.c V1.0 - Copyright (C) 1993/94/95/96 Jim Geuther */

/*
 *
 * Function:	stretch library functions
 * Author: 	Jim GEUTHER
 * Date:    	18-May-96
 * Environment: Personal Power System 850 + AIX V4.1.3.0
 *
 * This file contains support functions for performing image stretching
 * related tasks.
 *
 * History:
 * V1.00	Jim GEUTHER, ported from ImageKnife (Amiga) to Gimp (AIX)
 *
 */
 
/* The GIMP -- an image manipulation program
 * Copyright (C) 1995 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "gimp.h"
#include "stretch.h"

#define	sign( x )	( (x)>0 ? 1 : -1 )

/* #define	_DEBUG */

#ifdef	_DEBUG
#define	NULLP()	printf("%s.%ld: NULLPOINTER\n",__FILE__,__LINE__)
#define	DPRINTF(x) printf("%s.%ld: %s",__FILE__,__LINE__,x)
#else
#define	NULLP()	
#define	DPRINTF(x)
#endif

static void Stretch(
Image	input,
Image	output,
	long		x1,
	long		x2,
	long		y1,
	long		y2,
	long		yr,
	long		yw
	)
{

long	dx, dy, e, d, dx2;
long	sx, sy;
unsigned char *src_row,*dest_row,*src,*dest;
long channels, src_rowstride, dest_rowstride, ix;

channels = gimp_image_channels (input);
src_rowstride = gimp_image_width(input) * channels;
dest_rowstride = gimp_image_width(output) * channels;

dx = abs( x2 - x1 );
dy = abs( y2 - y1 );
sx = sign( x2 - x1 );
sy = sign( y2 - y1 );
e  = ( dy << 1) - dx;
dx2 = dx << 1;
dy <<= 1;

src_row = gimp_image_data (input);
dest_row = gimp_image_data (output);
for( d = 0; d <= dx; d++ ) {
	src = src_row + src_rowstride * yr  + (y1 * channels);
	dest = dest_row + dest_rowstride  * yw + (x1 * channels);
	for( ix = 0; ix < channels; ix++ ) *dest++ = *src++;
	while( e >= 0 ) {
		y1 += sy;
		e -= dx2;
	}
	x1 += sx;
	e += dy;
}
		
	
return;
}

void RectStretch(
Image	input,	/* Source image	*/
Image	output,	/* Destination image	*/
	long		xs1,	/* xs1, ys1, - first point of source	*/
	long		ys1,
	long		xs2,	/* xs2, ys2, - second point of source	*/
	long		ys2,
	long		xd1,	/* xd1, yd1 - first point of destination */
	long		yd1,
	long		xd2,
	long		yd2
	)
{

/*
** Graphics GEMS III page 411
*/

long	dx, dy, e, d, dx2 ;
long	sx, sy;
long	src_width,src_height,dest_width,dest_height;

/* Always clip */

dest_width = gimp_image_width( output );
dest_height = gimp_image_height( output );
src_width = gimp_image_width(input);
src_height = gimp_image_height(input);

if(xs1<0) xs1=0;
if(ys1<0) ys1=0;

if(xs2>=src_width) xs2=src_width-1;
if(ys2>=src_height) ys2=src_height-1;


if(xd1<0) xd1=0;
if(yd1<0) yd1=0;

if(xd2>=dest_width) xd2=dest_width-1;
if(yd2>=dest_height) yd2=dest_height-1;


dx = abs( yd2 - yd1 );
dy = abs( ys2 - ys1 );
sx = sign( yd2 - yd1 );
sy = sign( ys2 - ys1 );
e = ( dy << 1 ) - dx;
dx2 = dx << 1;
dy <<= 1;

#ifdef	_DEBUG
printf("%s.%ld: dx=%ld, xs1=%ld, ys1=%ld, xs2=%ld, ys2=%ld, "
	"xd1=%ld, yd1=%ld, xd2=%ld, yd2=%ld\n",
		__FILE__,__LINE__,
	dx, xs1, ys1, xs2, ys2, xd1, yd1, xd2, yd2 );
#endif
		
for( d = 0; d <= dx ; d++ )
{
	Stretch(input,output, xd1, xd2, xs1, xs2, ys1, yd1 );
	while( e >= 0 )
	{
		ys1 += sy;
		e -= dx2;
	}
	yd1 += sx;
	e += dy;
}

return;
}

static void Stretch2Lines(
Image	input,
Image	output,
	long		x1,
	long		x2,
	long		y1,
	long		y2,
	long		yr1,
	long		yw1,
	long		yr2,
	long		yw2
	)
{

long	dx, dy, e, d, dx2;
long	sx, sy;
unsigned char *src_row,*dest_row,*src1,*dest1,*src2,*dest2;
long channels, rowstride,ix;

channels = gimp_image_channels (input);
rowstride = gimp_image_width(input) * channels;

dx = abs( x2-x1 );
dy = abs( y2 - y1 );
sx = sign( x2-x1 );
sy = sign( y2 - y1 );
e  = (dy<<1)-dx;
dx2= dx << 1;
dy <<= 1;

src_row = gimp_image_data (input);
dest_row = gimp_image_data (output);
for( d = 0; d <= dx; d++ )
{
	src1 = src_row + rowstride * yr1  + (y1 * channels);
	src2 = src_row + rowstride * yr2  + (y1 * channels);	
	dest1 = dest_row + rowstride  * yw1 + (x1 * channels);
	dest2 = dest_row + rowstride  * yw2 + (x1 * channels);	
	for( ix = 0; ix < channels; ix++ ) {
		*dest1++ = *src1++;
		*dest2++ = *src2++;
	}

	while( e >= 0 )
	{
		y1 += sy;
		e -= dx2;
	}
	x1 += sx;
	e += dy;
}

return;
}

void CircleStretch(
Image	input,
Image	output,
long	SBMINX,	/* min x of source rectangle	(0) */
long	SBMAXX,	/* max x of source rectangle	(0) */
long	xc,	/* center of circle		*/
long	yc,
long	r	/* radius of circle		*/
	)
{
     
/*
 * CircleStretch:
 * Used for fisheye effect
 */

long	p = 3 - (r << 1),
		x = 0,
		y = r;
	
#ifdef	_DEBUG
printf("%s.%ld: minx=%ld, maxx=%ld, xc=%ld, yc=%ld, r=%ld\n",
	__FILE__,__LINE__,
	SBMINX, SBMAXX,
	xc,yc,r);
#endif
	
while( x < y )
{
	Stretch2Lines(input,output, xc-y, xc+y, SBMINX, SBMAXX, r-x, yc-x, r+x, yc+x );
	if( p < 0 )
	{
		p = p + ( x << 2) + 6;
	}
	else
	{
		Stretch2Lines(input,output, xc-x, xc+x, SBMINX, SBMAXX, r-y, yc-y, r+y, yc+y );
		p = p + ((x-y)<<2)+10;
		y--;
	}
	x++;

}

if( x == y )
{
	Stretch2Lines(input,output, xc-x, xc+x, SBMINX, SBMAXX, r-y, yc-y, r+y, yc+y );
}

return;
}



