#! /bin/sh

me=`basename $0`

if [ ! -d debian-tmp/usr/bin -o ! -d debian-tmp/usr/man ]
then
    >&2 echo $me: no correct debian-tmp directory here, aborting
    exit 2
fi

historic=" uncompress zcat zmore zless zcmp zdiff zgrep zegrep zfgrep "

# Add commands from the gzip package to the ones that should go in the
# historic package only.

for gzcmd in `dpkg -L gzip | sed -n -e '/compress$/d' -e '/bin/p'`
do
    if [ ! -d $gzcmd -a -e $gzcmd ]
    then
	cmd=`basename $gzcmd`
	if [ -z "`echo \"$historic\" | grep \" $cmd \"`" ]
	then
	    historic="$historic $cmd "
	fi
    fi
done

commands="`find debian-tmp/usr/bin ! -type d -a ! -name compress -print`"

notbasic=1
for c in $commands
do
    c=`basename $c`
    if [ -z "`echo \"$historic\" | grep \" $c \"`" ]
    then
	notbasic=0
 	break
    fi
done

exit $notbasic

