#!/bin/sh
# The default path should be /usr/local

# Get some info from configure
# chmod +x ./scripts/setsomevars

machine=@MACHINE_TYPE@
system=@SYSTEM_TYPE@
version=@VERSION@
export machine system version

#make

# This should really be integrated with automake and not duplicate the
# installation list.

BASE=mysql-$version-$system-$machine
mkdir $BASE $BASE/bin $BASE/data $BASE/data/mysql $BASE/data/test \
 $BASE/include $BASE/lib $BASE/perl \
 $BASE/share $BASE/share/mysql $BASE/tests $BASE/scripts $BASE/bench

for i in BUGS NEWS CREDITS sql/ChangeLog \
 INSTALL-BINARY INSTALL-SOURCE PORTING PUBLIC README TODO \
 Docs/manual.html Docs/manual.txt Docs/manual_toc.html
do
  ln $i $BASE
done

for i in extra/comp_err client/mysql sql/mysqld client/mysqlshow \
 extra/replace isam/isamchk client/mysqladmin client/mysqldump \
 extra/perror
do
  ln $i $BASE/bin
done

ln include/* $BASE/include; rm $BASE/include/Makefile*; rm $BASE/include/*.in
ln tests/*.res tests/*.tst tests/*.pl $BASE/tests
ln data/mysql/*.frm $BASE/data/mysql 
cp client/libmysqlclient.a $BASE/lib
cd perl; cp -r . ../$BASE/perl; rm Makefile */Makefile */*/Makefile ; cd ..
sh -c "cd $BASE/perl ; make clean > /dev/null 2>&1"
cp -r sql/share/* $BASE/share/mysql; rm -f $BASE/share/mysql/Makefile* $BASE/share/mysql/*/*.OLD

ln scripts/* $BASE/bin
rm -f $BASE/bin/Makefile* $BASE/bin/*.in $BASE/bin/*.sh $BASE/bin/mysql_install_db $BASE/bin/make_binary_distribution $BASE/bin/setsomevars
$BASE/bin/replace \@localstatedir\@ ./data \@bindir\@ ./bin \@scriptdir\@ ./bin < scripts/mysql_install_db.sh > $BASE/scripts/mysql_install_db
chmod a+x $BASE/bin/* $BASE/scripts/*

cp -r bench/* $BASE/bench
rm -f $BASE/bench/*.sh $BASE/bench/Makefile*

# hack for installation at TCX where perl is /my/gnu/bin/perl5
$BASE/bin/replace /my/gnu/bin/perl5 /usr/bin/perl /my/gnu/bin /usr/bin -- $BASE/scripts/* $BASE/bench/* $BASE/tests/* $BASE/perl/Makefile $BASE/perl/*/Makefile $BASE/perl/*/*/Makefile $BASE/perl/Mysql-modules/*/*.t $BASE/perl/Mysql-modules/*/*/*.t $BASE/perl/Mysql-modules/blib/script/* $BASE/DBI/README $BASE/bin/zap $BASE/bin/mysqlaccess > /dev/null 2>&1

#
# If we are compiling with gcc, add libgcc.a into libmysqlclient.a
#

if test "@GXX@" = "yes"
then
  cd $BASE/lib
  gcclib=`@CC@ --print-libgcc-file`
  if test $? -ne 0
  then
    print "Warning: Couldn't find libgcc.a!"
  else
    ar -x $gcclib
    ar -r libmysqlclient.a *.o
    rm *.o
  fi
  cd ../..
fi

#
# this is needed to prefere gnu tar instead of tar because tar can't always
# handle long filenames
#

PATH_DIRS=`echo $PATH | sed -e 's/^:/. /' -e 's/:$/ ./' -e 's/::/ . /g' -e 's/:/ /g' `
which_1 ()
{
  for cmd
  do
    for d in $PATH_DIRS
    do
      for file in $d/$cmd
      do
	if test -x $file -a ! -d $file
	then
	  echo $file
	  exit 0
	fi
      done
    done
  done
  exit 1
}

#
# Create the result tar file
#

tar=`which_1 gtar`
if test "$?" = "1" -o "$tar" = ""
then
  tar=tar
fi

$tar cvf - $BASE | gzip > $BASE.tgz 

rm -rf $BASE

echo "$BASE.tgz created"

