/* convert the QT keycodes in an useful form for kkeydlg */

#include <stdio.h>
#include <string.h>

#define CONV_FILE "ckey"
#define ADD_CONV_FILE "ackey"

FILE *qt_key, *conv_key;     

void fin(char *msg)
{
	fclose(qt_key);
	fclose(conv_key);
	printf(msg);
	exit(0);
}

void main( int argc, char ** argv )
{
	char qt_path[200], line[200];
	char *token, *result;
	int nb_lines;
	
	if ( argc != 2 ) {
		printf("Need QTdir in argument\n");
		exit(1);
	}
	
	sprintf(qt_path, "%s/include/qkeycode.h", argv[1]);
	qt_key = fopen(qt_path, "r");
	if ( qt_key==0L ) {
		printf("Unable to read %s\n", qt_path);
		exit(0);
	}
	
	conv_key = fopen(CONV_FILE, "w");
	if ( conv_key==0L ) {
		printf("Unable to create %s\n", CONV_FILE);
		exit(0);
	}
	
	nb_lines = 0;
	do {
		result = fgets(line, 200, qt_key);
		if ( result==0L ) break;
		token = strtok(line, " ");
		if ( strcmp(token, "#define")!=0 ) continue;
		token = strtok(0L, "\t\t");
		if ( strncmp(token, "Key_", 4)!=0 ) continue;
		if ( nb_lines!=0 ) fprintf(conv_key, ",\n");        
		fprintf(conv_key, "\t{ \"%s\"", token+4);
		token = strtok(0L,"\t\n");
		fprintf(conv_key, ", %s }", token);
		nb_lines++;
	} while (1);
	fprintf(conv_key, "\n};\n\n");
	fclose(conv_key);
	
	conv_key = fopen(ADD_CONV_FILE, "w");
	if ( conv_key==0L ) {
		printf("Unable to read %s\n", ADD_CONV_FILE);
        exit(0);
	}

	fprintf(conv_key, "/* this file has been generated by convert_key */\n\n");
	fprintf(conv_key, "typedef struct {\n\t char name[15];\n\t int code;\n} KKey;\n\n");
	fprintf(conv_key, "#define MAX_KEY_LENGTH 15\n#define MAX_KEY_MODIFIER_LENGTH 15\n");
	fprintf(conv_key, "#define NB_KEYS %i\n\n", nb_lines);
	fprintf(conv_key, "KKey KKeys[NB_KEYS] = {\n");
	
	fin("conversion done\n");
}

		
	
		
			
