.\" $NCDId: @(#)AuSRecTN.man,v 1.2 1995/05/23 23:53:11 greg Exp $
.\" copyright 1994 Steven King
.\"
.\" portions are
.\" * Copyright 1993 Network Computing Devices, Inc.
.\" *
.\" * Permission to use, copy, modify, distribute, and sell this software and its
.\" * documentation for any purpose is hereby granted without fee, provided that
.\" * the above copyright notice appear in all copies and that both that
.\" * copyright notice and this permission notice appear in supporting
.\" * documentation, and that the name Network Computing Devices, Inc. not be
.\" * used in advertising or publicity pertaining to distribution of this
.\" * software without specific, written prior permission.
.\" * 
.\" * THIS SOFTWARE IS PROVIDED 'AS-IS'.  NETWORK COMPUTING DEVICES, INC.,
.\" * DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT
.\" * LIMITATION ALL IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
.\" * PARTICULAR PURPOSE, OR NONINFRINGEMENT.  IN NO EVENT SHALL NETWORK
.\" * COMPUTING DEVICES, INC., BE LIABLE FOR ANY DAMAGES WHATSOEVER, INCLUDING
.\" * SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES, INCLUDING LOSS OF USE, DATA,
.\" * OR PROFITS, EVEN IF ADVISED OF THE POSSIBILITY THEREOF, AND REGARDLESS OF
.\" * WHETHER IN AN ACTION IN CONTRACT, TORT OR NEGLIGENCE, ARISING OUT OF OR IN
.\" * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\"
.\" $Id: AuSoundRecordToFileN.man,v 0.1 1994/09/14 18:10:08 sking Exp $
.TH AuSoundRecordToFileN 3 "1.2" "soundlib"
.SH \fBName\fP
\fBAuSoundRecordToFileN\fP \- 
.SH \fBSynopsis\fP
#include <audio/audiolib.h>
.br
#include <audio/soundlib.h>
.sp 1
\fBAuEventHandlerRec\fP *\fBAuSoundRecordToFileN\fP(\fIserver\fP, \fIfilename\fP, \fIsource\fP, \fIgain\fP, \fInum_samples\fP, \fIcallback\fP, \fIcallback_data\fP, \fImode\fP, \fIfile_format\fP, \fIcomment\fP, \fIrate\fP, \fIdata_format\fP, \fIflow\fP, \fIvolume_mult_elem\fP, \fIstatus\fP)
.br
    \fBAuServer\fP *\fIserver\fP;
.br
    char *\fIfilename\fP;
.br
    \fBAuDeviceID\fP \fIsource\fP;
.br
    \fBAuFixedPoint\fP \fIgain\fP;
.br
    \fBAuUint32\fP \fInum_samples\fP;
.br
    void (*\fIcallback\fP)(\fBAuServer\fP *, \fBAuEventHandlerRec\fP *, \fBAuEvent\fP *, \fBAuPointer\fP);
.br
    \fBAuPointer\fP \fIcallback_data\fP;
.br
    int \fImode\fP;
.br
    int \fIfile_format\fP;
.br
    char * \fIcomment\fP;
.br
    \fBAuUint32\fP \fIrate\fP;
.br
    int \fIdata_format\fP;
.br
    \fBAuFlowID\fP *\fIflow\fP;
.br
    int *\fIvolume_mult_elem\fP;
.br
    \fBAuStatus\fP *\fIstatus\fP;
.SH \fBArguments\fP
.IP \fIserver\fP 1i
Specifies the connection to the audio server.
.IP \fIfilename\fP 1i
Specifies the name of the file to record to.
.IP \fIsource\fP 1i
Specifies the input device to record from.
.IP \fIgain\fP 1i
Specifies the gain for the input device.
.IP \fInum_samples\fP 1i
Specifies the number of samples to record.
Use \fBAuUnlimitedSamples\fP to record an unlimited number of samples.
.IP \fIcallback\fP 1i
Specifies the procedure to be called for additional event processing.
.IP \fIcallback_data\fP 1i
Specifies any additional arguments to be passed to callback.
.IP \fImode\fP 1i
Specifies the line mode for the input device.
Currently the following line modes are defined: \fBAuDeviceInputModeNone\fP, \fBAuDeviceInputModeLineIn\fP, \fBAuDeviceInputModeMicrophone\fP.
.IP \fIfile_format\fP 1i
Specifies the file format.
Currently, the following file formats are supported: \fBSoundFileFormatSnd\fP, \fBSoundFileFormatVoc\fP, \fBSoundFileFormatWave\fP, \fBSoundFileFormatAiff\fP, \fBSoundFileFormatSvx\fP.
.IP \fIcomment\fP 1i
Specifies a comment to embedded in the file.
.IP \fIrate\fP 1i
Specifies the sample rate to record at.
.IP \fIdata_format\fP 1i
Specifies the data format.
Currently, the following data formats are defined:
\fBAuFormatULAW8\fP, \fBAuFormatLinearUnsigned8\fP, \fBAuFormatLinearSigned8\fP, \fBAuFormatLinearSigned16MSB\fP, \fBAuFormatLinearUnsigned16MSB\fP, \fBAuFormatSignedLinear16LSB\fP, and \fBAuFormatLinearUnsigned16LSB\fP.
.IP \fIflow\fP 1i
If non-NULL, returns the flow ID.
.IP \fIvolume_mult_elem\fP 1i
Accord to the comment in the source, not implemented.
.IP \fIstatus\fP 1i
If non-NULL, flush the output buffer and return the status from the server.
.SH \fBDescription\fP
\fBAuSoundRecordToFileN\fP creates a flow to record from \fIsource\fP into \fIfilename\fP and returns a pointer to the event handler created or NULL if there was an error.
.SH \fBErrors\fP
\fBAuBadDevice\fP.
.SH \fBSee Also\fP
\fBAuSoundRecord\fP,
\fBAuSoundRecordToBucket\fP,
\fBAuSoundRecordToData\fP,
\fBAuSoundRecordToFile\fP.
.sp 1
audiolib \- \fBNetwork Audio System\fP C Language Interface
