# Copyright (c) 1993 by Sanjay Ghemawat
#############################################################################
# Bug Report dialog
#
# Commands
#
#	bug_notify <mailer> <email> <message>
#		Handle software error

# Hidden global variables
#
#	bug_done		Is bug interaction finished

set bug_done no

proc bug_notify {mailer email message} {
    bug_make
    bug_interact $mailer $email $message
}

proc bug_make {} {
    set f .bug_dialog
    if [winfo exists $f] {return}

    toplevel $f -class Dialog
    wm title $f {Internal Error}
    wm protocol $f WM_DELETE_WINDOW {set bug_done cancel}

    frame $f.top -relief raised -bd 1
    frame $f.mid -relief raised -bd 1

    make_buttons $f.bot 2 {
	{{Dismiss}		{set bug_done cancel}}
	{{Save}			{set bug_done save}}
	{{Mail Report}		{set bug_done send}}
    }

    label $f.icon -bitmap error
    message $f.warn -aspect 400 -text {Uninitialized message}
    bug_textwin $f.message {Message}
    bug_textwin $f.edit {User Notes}

    $f.message.text configure -state disabled
    $f.edit.text configure -state normal

    pack $f.icon -in $f.top -side left -padx 5m -pady 5m
    pack $f.warn -in $f.top -side right -padx 5m -pady 5m -expand 1 -fill both

    pack $f.edit -in $f.mid -side top -padx 5m -pady 5m -expand 1 -fill both
    pack $f.message -in $f.mid -side top -padx 5m -pady 5m -expand 1 -fill both

    pack $f.top -side top -fill both
    pack $f.mid -side top -expand 1 -fill both
    pack $f.bot -side top -fill both

    wm withdraw $f
    update
}

# Build text window
proc bug_textwin {w label} {
    frame $w -bd 2 -relief groove
    label $w.label -text $label -relief raised -bd 1 -anchor w

    frame $w.in
    text $w.text -width 40 -height 6 -wrap none -relief raised -bd 1\
	-yscroll [list $w.scroll set]
    scrollbar $w.scroll -orient vertical -relief raised -bd 1\
	-command [list $w.text yview]

    pack $w.label -side top -fill x
    pack $w.in -side top -expand 1 -fill both

    pack $w.text -side left -expand 1 -fill both
    pack $w.scroll -side right -fill y
}

proc bug_interact {mailer email message} {
    set f .bug_dialog

    # Configure text window height
    #set height [llength [split $message "\n"]]
    #if {$height > 20} {set height 20}
    #if {$height <  4} {set height  4}
    #$f.message.text configure -height $height

    # Configure notice
    $f.warn configure -text [format [join {
	"An internal error has occurred.  You can send a bug report to"
	"the author (%s) by clicking on the \"Mail Report\" button"
	"at the bottom of this dialog.  The text displayed below"
	"will be the only information sent to the author.  If you do not"
	"want to send a bug report, click on the \"Dismiss\" button."
	"If you want to send extra comments to the author, type them into"
	"the area below."
    }] $email]

    $f.message.text configure -state normal
    $f.message.text delete 1.0 end
    $f.message.text insert 1.0 $message
    $f.message.text configure -state disabled

    $f.edit.text delete 1.0 end

    global bug_done
    set bug_done no
    dialog_run {} $f $f.edit.text bug_done

    if ![string compare $bug_done {cancel}] return

    set text [bug_extract]
    switch -exact -- $bug_done {
	save {
	    bug_save $email $text
	}
	send {
	    # Try different ways of sending mail
	    if [catch {bug_mail1 $mailer $email $text}] {
		catch {bug_mail2 $mailer $email $text}
	    }
	}
    }
}

proc bug_extract {} {
    set f .bug_dialog
    set text1 [$f.edit.text get 1.0 end]
    set text2 [$f.message.text get 1.0 end]

    return "$text1\n========\n$text2========"
}

proc bug_save {email text} {
    set msg {Select file to which message should be saved}
    if ![get_file_name {} {File} $msg file] return

    catch {
	set f [open $file w]
	catch {puts $f "To: $email"}
	catch {puts $f "Subject: Bug report"}
	catch {puts $f "--------"}
	catch {puts $f $text}
	close $f
    }
}
		
proc bug_mail1 {mailer email text} {
    set f .bug_dialog

    set mailproc [open [list | $mailer -s {Bug report} $email] w]
    catch {puts $mailproc $text}
    close $mailproc
}

proc bug_mail2 {mailer email text} {
    set f .bug_dialog

    set mailproc [open [list | $mailer $email] w]
    catch {puts $mailproc {Subject: Bug report}}
    catch {puts $mailproc $text}
    close $mailproc
}
