### rules.mak - Makefile rules common to all systems.
# This file should be portable to all systems, so it can be included in or
# concatenated with all system-specific makefiles.
# Note the regexp.$O rule must be defined in a system-specific file.

# Predefined variables:
#   SYS          - required system type (unix, os2)
#   O            - required object suffix (e.g., "o" or "obj")
#   BUILDERS     - optional list of system-specific dependancies


command.$O: command.c config.h port.h dstring.h tf.h malloc.h variable.h \
  util.h tfio.h commands.h command.h world.h socket.h output.h \
  macro.h keyboard.h expand.h search.h signals.h $(BUILDERS)

dstring.$O: dstring.c config.h port.h malloc.h dstring.h $(BUILDERS)

expand.$O: expand.c config.h port.h dstring.h tf.h malloc.h variable.h util.h \
  tfio.h macro.h signals.h socket.h search.h output.h keyboard.h \
  expand.h commands.h command.h $(BUILDERS)

help.$O: help.c config.h port.h dstring.h variable.h \
  tfio.h commands.h $(BUILDERS)

history.$O: history.c config.h port.h dstring.h tf.h malloc.h variable.h \
  util.h tfio.h history.h socket.h world.h output.h macro.h \
  commands.h search.h $(BUILDERS)

keyboard.$O: keyboard.c config.h port.h dstring.h tf.h malloc.h variable.h \
  util.h tfio.h keyboard.h macro.h output.h history.h expand.h search.h \
  commands.h $(BUILDERS)

macro.$O: macro.c config.h port.h dstring.h tf.h malloc.h variable.h util.h \
  tfio.h search.h world.h macro.h keyboard.h expand.h socket.h \
  commands.h command.h $(BUILDERS)

main.$O: main.c config.h port.h dstring.h tf.h malloc.h variable.h util.h \
  tfio.h history.h world.h socket.h macro.h output.h signals.h command.h \
  keyboard.h $(BUILDERS)

makehelp.$O: makehelp.c config.h port.h $(BUILDERS)

malloc.$O: malloc.c config.h port.h signals.h malloc.h $(BUILDERS)

output.$O: output.c config.h port.h dstring.h tf.h malloc.h variable.h util.h \
  tfio.h world.h socket.h output.h macro.h search.h tty.h $(BUILDERS)

process.$O: process.c config.h port.h dstring.h tf.h malloc.h variable.h \
  util.h tfio.h history.h world.h process.h socket.h expand.h commands.h \
  $(BUILDERS)

search.$O: search.c config.h port.h malloc.h search.h $(BUILDERS)

signals.$O: signals.c config.h port.h dstring.h tf.h malloc.h variable.h \
  util.h tfio.h world.h process.h tty.h output.h socket.h signals.h $(BUILDERS)

socket.$O: socket.c config.h port.h dstring.h tf.h malloc.h variable.h util.h \
  tfio.h fd_set.h history.h world.h socket.h output.h process.h \
  macro.h keyboard.h commands.h command.h signals.h search.h tty.h $(BUILDERS)

tfio.$O: tfio.c config.h port.h dstring.h tf.h malloc.h variable.h util.h \
  tfio.h fd_set.h output.h macro.h history.h search.h $(BUILDERS)

tty.$O: tty.c config.h port.h tf.h malloc.h variable.h dstring.h util.h \
  tty.h output.h macro.h $(BUILDERS)

util.$O: util.c config.h port.h dstring.h tf.h malloc.h variable.h util.h \
  tfio.h output.h tty.h $(BUILDERS)

variable.$O: variable.c config.h port.h dstring.h tf.h malloc.h variable.h \
  util.h tfio.h output.h socket.h search.h commands.h process.h $(BUILDERS)

world.$O: world.c config.h port.h dstring.h tf.h malloc.h variable.h util.h \
  tfio.h history.h world.h process.h macro.h commands.h $(BUILDERS)

