/* tr_out.c  94.05.06
 * Copyright 1983-1992   Albert Davis
 * tr,dc analysis output functions (and some ac)
 */
#include "ecah.h"
#include "branch.h"
#include "dc.h"
#include "io.h"
#include "mode.h"
#include "probh.h"
#include "status.h"
#include "tr.h"
#include "declare.h"
/*--------------------------------------------------------------------------*/
	void	dc_out(const dc_t*);
	void	tr_out(const transient_t*);
	void	tr_head(double,double,int,const char*);
	void	tr_print(double);
	void	tr_alarm(void);
/*--------------------------------------------------------------------------*/
extern const struct ioctrl io;
extern       struct status stats;
extern const probe_t *probelist[];
extern const probe_t *alarmlist[];
extern const int sim_mode;
/*--------------------------------------------------------------------------*/
/* dc_out: output the data, "keep" for ac reference
 * is separate from tr_out only because of old plot functions
 */
void dc_out(const dc_t *dc)
{
 time_start(&(stats.output));
 if (dc->printnow){
    trkeep();
    plottr(*dc->sweep[0]);
    tr_print(*dc->sweep[0]);
    tr_alarm();
    stats.iter[iPRINTSTEP] = 0;
    stats.control[cSTEPS] = 0;
 }
 time_stop(&(stats.output));
}
/*--------------------------------------------------------------------------*/
/* tr_out: output the data, "keep" for ac reference
 */
void tr_out(const transient_t *tr)
{
 time_start(&(stats.output));
 if (tr->printnow){
    trkeep();
    plottr(tr->time0);
    tr_print(tr->time0);
    tr_alarm();
    stats.iter[iPRINTSTEP] = 0;
    stats.control[cSTEPS] = 0;
 }
 time_stop(&(stats.output));
}
/*--------------------------------------------------------------------------*/
/* tr_head: print column headings and draw plot borders
 */
void tr_head(double start, double stop, int linear, const char *col1)
{
 if (!plopen(sim_mode,start,stop,linear)){
    if (col1  &&  *col1)
       mprintf(io.where,"#%-10s", col1);
    if (probelist[sim_mode]){
       int ii;
       for (ii = 0;  *probelist[sim_mode][ii].what;  ii++){
	  probe_t prb;	/* to hide MSC BUG */
	  prb = probelist[sim_mode][ii];
	  mprintf(io.where," %-10.10s", probename(prb));
       }
    }
    mprintf(io.where,"\n");
 }
}
/*--------------------------------------------------------------------------*/
/* tr_print: print the list of results (text form) to io.where
 * The argument is the first column (independent variable, aka "x")
 */
void tr_print(double x)
{
 if (!io.ploton){
    if (x != NOT_VALID)
       mprintf(io.where,ftos(x,"           ",5,io.formaat));
    if (probelist[sim_mode]){
       int ii;
       for (ii = 0;  *probelist[sim_mode][ii].what;  ii++){
	  double value;
	  probe_t prb;	/* to hide MSC BUG */
	  prb = probelist[sim_mode][ii];
	  value = trprobe(prb);
	  mprintf(io.where,ftos(value,"           ",5,io.formaat));
	  if (sim_mode == sFOURIER)
	     fosave(value);
       }
    }
    mprintf(io.where,"\n");
 }
}
/*--------------------------------------------------------------------------*/
/* tr_alarm: print a message when a probe is out of range
 */
void tr_alarm(void)
{
 if (alarmlist[sim_mode]){
    int ii;
    for (ii = 0;  *alarmlist[sim_mode][ii].what;  ii++){
       double value;
       probe_t prb;	/* to hide MSC BUG */
       prb = alarmlist[sim_mode][ii];
       value = trprobe(prb);
       if (!inorder(prb.lo, value, prb.hi)){
          mprintf(io.where, "%s=%s\n", 
	  	probename(prb), ftos(value,"           ",5,io.formaat));
       }
    }
 }
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
