/* time_it.c  93.12.21
 * Copyright 1983-1992   Albert Davis
 * Time a command, or whatever
 */
/*--------------------------------------------------------------------------*/
#include "ecah.h"
#include "error.h"
#include "status.h"
#include "declare.h"
/*--------------------------------------------------------------------------*/
	void	time_fullreset(struct time_s*);
	void	time_reset(struct time_s*);
	void	time_zstart(struct time_s*);
	void	time_start(struct time_s*);
	void	time_stop(struct time_s*);
	void	time_check(struct time_s*);
/*--------------------------------------------------------------------------*/
extern char e_int[];
/*--------------------------------------------------------------------------*/
void time_fullreset(struct time_s *y)
{
 y->total_user  = 0.;
 y->total_system= 0.;
 time_reset(y);
}
/*--------------------------------------------------------------------------*/
void time_reset(struct time_s *y)
{
 y->last_user   = 0.;
 y->last_system = 0.;
 y->ref_user    = 0.;
 y->ref_system  = 0.;
 y->running = NO;
}
/*--------------------------------------------------------------------------*/
void time_zstart(struct time_s *y)
{
 time_reset(y);
 time_start(y);
}
/*--------------------------------------------------------------------------*/
void time_start(struct time_s *y)
{
 if (y->running){
    error(bWARNING, e_int, "clock already running");
    time_check(y);
 }else{
    struct rusage x;
    (void)getrusage(RUSAGE_SELF,&x);
    y->ref_user =
       (double)(x.ru_utime.tv_sec) + (double)(x.ru_utime.tv_usec)*1e-6; 
    y->ref_system =
       (double)(x.ru_stime.tv_sec) + (double)(x.ru_stime.tv_usec)*1e-6; 
    y->running = YES;
 }
}
/*--------------------------------------------------------------------------*/
void time_stop(struct time_s *y)
{
 if (!y->running){
    error(bWARNING, e_int, "clock not running");
 }else{
    struct rusage x;
    double utime, stime;
    double runtime;
    (void)getrusage(RUSAGE_SELF,&x);
    
    utime=(double)(x.ru_utime.tv_sec)+(double)(x.ru_utime.tv_usec)*1e-6; 
    runtime = utime - y->ref_user;
    y->ref_user    =  0.;
    y->last_user   += runtime;
    y->total_user  += runtime;
    
    stime=(double)(x.ru_stime.tv_sec)+(double)(x.ru_stime.tv_usec)*1e-6; 
    runtime = stime - y->ref_system;
    y->ref_system  =  0.;
    y->last_system += runtime;
    y->total_system+= runtime;
    y->running = NO;
 }
}
/*--------------------------------------------------------------------------*/
void time_check(struct time_s *y)
{
 if (y->running){
    time_stop(y);
    time_start(y);
 }
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
