/* prb.name.c  94.03.20
 * Copyright 1983-1992   Albert Davis
 */
#include "ecah.h"
#include "branch.h"
#include "probh.h"
#include "status.h"
#include "declare.h"
/*--------------------------------------------------------------------------*/
	char	*probename(probe_t);
/*--------------------------------------------------------------------------*/
extern const struct status stats;
/*--------------------------------------------------------------------------*/
/* probename: returns a string corresponding to a possible probe point
 * (suitable for printing)
 * It has nothing to do with whether it was selected or not
 * the return string is static, and overwritten on every call.
 */
char *probename(probe_t prb)
{
 static char string[BUFLEN+8];
	
 if (*prb.what){
    if (!prb.brh){
       sprintf(string, "%s(%u)", prb.what, prb.node);
    }else{
       sprintf(string, "%s(%s)", prb.what, printlabel(prb.brh,NO));
    }
 }else{
    sprintf(string,"undefined");
 }
 strcpy(&(string[BUFLEN-3]), "++");
 return string;
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
