/* globals.c  94.11.20
 * Copyright 1983-1992   Albert Davis
 */
#include "ecah.h"
#include "ac.h"
#include "branch.h"
#include "error.h"
#include "io.h"
#include "mode.h"
#include "nodestat.h"
#include "options.h"
#include "probh.h"
#include "tr.h"
#include "status.h"
/*--------------------------------------------------------------------------*/
/* sparse matrix */
double *reals, *imags;		/* big array allocation bases		*/
double **rerow, **imrow;	/* array of row pointers		*/
double **recol, **imcol;	/* array of column pointers		*/
double **redia, **imdia;	/* array of diagonal pointers		*/

/* nodes, hold between commands */
struct nodestat *nstat;		/* node status flags			*/
struct nodestuff ns;		/* dctran node voltages, currents, etc.	*/

/* other sparse matrix stuff */
unsigned aspace;		/* count of non-zero array elements	*/
double zero;			/* a constant, could change if bugs	*/
/*--------------------------------------------------------------------------*/
/* other (the ultimate in disorder) */
ac_t ac;			/* stuff for ac analysis		*/
transient_t *tr;		/* stuff for transient analysis		*/
struct status stats;		/* timing data for status command	*/
branch_t *insertbefore;		/* place to add new elements (subckt?)	*/
int inc_mode;			/* flag: make incremental changes	*/
int bypass_ok;			/* flag: ok to bypass model evaluation	*/
double last_time;		/* time at which "volts" is valid	*/
double trtime0;			/* transient analysis time		*/
double genout;			/* tr dc input to circuit (generator)	*/
probe_t *alarmlist[sCOUNT];	/* list of alarm points			*/
probe_t *plotlist[sCOUNT];	/* list of plot points			*/
probe_t *probelist[sCOUNT];	/* list of print points			*/
double temp;			/* local temperature			*/
char head[BUFLEN+3];
FILE *stream[MAXHANDLE+1];	/* reverse of fileno()			*/
/*--------------------------------------------------------------------------*/
/* command interpreter, control stuff */
jmp_buf envp;			/* environment for setjmp, longjmp	*/
int cmdcount;			/* command counter, for history		*/
int crtplot = NO;		/* flag: is plotting on the crt		*/

/* sweep command */
int swp_count[RECURSE];		/* sweep counter			*/
int swp_steps[RECURSE];		/* sweep number of steps		*/
int swp_type[RECURSE];		/* type of sweep (log or linear)	*/
int swp_nest;			/* sweep nesting (recursion) level	*/

/* flags: what is it doing */
int worstcase;			/* bits flag: worst case, etc. mode	*/
int run_mode;			/* variations on handling of dot cmds	*/
int sim_mode;			/* simulation type (AC, DC, ...)	*/
int sim_phase;			/* phase of simulation (iter, init-dc, )*/

/* initial conditions fudge (yuck) */
int in_curr;			/* flag: initial current exists		*/
int in_volt;			/* flag: initial voltage exists		*/
int in_cond;			/* flag: generic initial cond exists	*/
double init_curr;		/* initial current			*/
double init_volt;		/* initial voltage			*/
double init_cond;		/* generic initial condition		*/

/* options : options command */
struct options opt = {oDEFAULT_acct, oDEFAULT_list, oDEFAULT_nomod,
   oDEFAULT_page, oDEFAULT_node, oDEFAULT_opts, oDEFAULT_gmin,
   oDEFAULT_reltol, oDEFAULT_abstol, oDEFAULT_vntol, oDEFAULT_trtol,
   oDEFAULT_chgtol, oDEFAULT_pivtol, oDEFAULT_pivrel, oDEFAULT_numdgt,
   oDEFAULT_tnom, oDEFAULT_cptime, oDEFAULT_limtim, oDEFAULT_limpts,
   oDEFAULT_lvlcod, oDEFAULT_lvltim, oDEFAULT_method, oDEFAULT_maxord,
   oDEFAULT_defl, oDEFAULT_defw, oDEFAULT_defad, oDEFAULT_defas,
   oDEFAULT_seed, oDEFAULT_wczero, oDEFAULT_damp, oDEFAULT_floor,
   oDEFAULT_tempamb, oDEFAULT_short, oDEFAULT_picky, oDEFAULT_inwidth,
   oDEFAULT_outwidth, oDEFAULT_xdivisions, oDEFAULT_ydivisions,
   oDEFAULT_order, oDEFAULT_mode, oDEFAULT_transits,
   oDEFAULT_dupcheck, oDEFAULT_bypass, oDEFAULT_incmode, oDEFAULT_lubypass,
   oDEFAULT_limit, oDEFAULT_vmax, oDEFAULT_vmin, oDEFAULT_dtmin, 
   oDEFAULT_dtratio, oDEFAULT_rstray, oDEFAULT_cstray,
   oDEFAULT_harmonics, oDEFAULT_trstepgrow, oDEFAULT_trstepshrink, 
   oDEFAULT_trreject, oDEFAULT_showall, oDEFAULT_foooo, oDEFAULT_diodeflags,
   oDEFAULT_mosflags, oDEFAULT_lowlim, oDEFAULT_uplim,
   {oDEFAULT_itl0, oDEFAULT_itl1, oDEFAULT_itl2, oDEFAULT_itl3,
   oDEFAULT_itl4, oDEFAULT_itl5, oDEFAULT_itl6, oDEFAULT_itl7, oDEFAULT_itl8}};

/* io control */
struct ioctrl io = {ioDEFmstdin, ioDEFmstdout, ioDEFmstderr, ioDEFmpr,
   ioDEFwhere, ioDEFformaat, ioDEFwhence, ioDEFsuppresserrors, ioDEFechoflag,
   ioDEFprintflag, ioDEFincipher, ioDEFoutcipher, ioDEFpack, ioDEFploton,
   ioDEFplotset};

/* commonly used error messages */
char e_int[]	= "internal error: %s\n";
char e_om[]	= "out of memory: %s\n";
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
