/* d_vswtch.h  94.10.02
 * Copyright 1994  Albert Davis
 * data structures for voltage controlled switch
 */
#define	tVOLTAGE	1
#define	tCURRENT	2

#define vswDEFMOD_modelname	"-sw-"
#define vswDEFMOD_vt	0.0
#define vswDEFMOD_vh	0.0
#define vswDEFMOD_ron	1.0
#define vswDEFMOD_roff	1e+12
#define vswDEFMOD_type	tVOLTAGE

#define vswDEFDEV_modelname	vswDEFMOD_modelname
#define	vswDEFDEV_ic	swUNKNOWN

#define swUNKNOWN 	0
#define	swON		1
#define swOFF		-1

struct vswtch {
   generic_t	*x;		/* (not used) */
   size_t	ssize;
   const struct vswtchmod *m;	/* model params */
   char 	modelname[LABELEN+1];
   int		ic;		/* initial state */
   int		current_state;	/* state 1 iter ago (may be bad) */
   int		previous_state;	/* state 1 time or step ago (known good) */
};

struct vswtchmod {
   generic_t	*x;		/* owned expansion stuff (not used)	*/
   size_t	ssize;		/* spice2 parameters			*/
   double	vt;		/* threshold voltage			*/
   double	vh;		/* hysteresis voltage			*/
   double	ron;		/* on resistance			*/
   double	roff;		/* off resistance			*/
   int		type;		/* current or voltage			*/
};


