/* dev_trnlin.h  11/19/91
 * Copyright 1983-1992   Albert Davis
 * structures, etc. for transmission lines
 */
#define DEFAULT_Z0	0.
#define DEFAULT_TD	0.
#define DEFAULT_F	0.
#define DEFAULT_NL	0.25
#define NUM_INIT_COND	4
struct trnlin {
   generic_t *x;
   size_t  ssize;
   double  z0;			/* characteristic impedance		*/
   double  td;			/* delay time (not used, yet)		*/
   double  f;			/* specification frequency		*/
   double  nl;			/* length (wavelengths) at f		*/
   double  ic[NUM_INIT_COND];	/* initial conditions: v1, i1, v2, i2	*/
   double  reson;		/* quarter wave frequency 		*/
   int     icset;		/* flag: initial condition set		*/
};
