/* d_mosc.c  93.12.19
 * Copyright 1983-1992   Albert Davis
 * mos model subcircuit functions
 */
#include "ecah.h"
#include "branch.h"
#include "d_mos.h"
#include "declare.h"
/*--------------------------------------------------------------------------*/
	void	mos2_ids0(branch_t*);
	void	mos2_gmf0(branch_t*);
	void	mos2_gmr0(branch_t*);
	void	mos2_gds0(branch_t*);
	void	mos2_gmbf0(branch_t*);
	void	mos2_gmbr0(branch_t*);
	void	mos_cgb0(branch_t*);
	void	mos_cgd0(branch_t*);
	void	mos_cgs0(branch_t*);
	void	mos2_ids1(branch_t*);
	void	mos2_gmf1(branch_t*);
	void	mos2_gmr1(branch_t*);
	void	mos2_gds1(branch_t*);
	void	mos2_gmbf1(branch_t*);
	void	mos2_gmbr1(branch_t*);
	void	mos_cgb1(branch_t*);
	void	mos_cgd1(branch_t*);
	void	mos_cgs1(branch_t*);
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
/* mos2_ids: drain-source current calculations
 * returns ids
 */
/*--------------------------------------------------------------------------*/
void mos2_ids0(branch_t *brh)
{
 brh->y0.f0 = brh->y0.x * brh->y0.f1;
}
/*--------------------------------------------------------------------------*/
void mos2_ids1(branch_t *brh)
{
 struct mos *x;
 struct mmod *m;
 
 x = (struct mos*)brh->parent->x;
 m = x->m;
 if (brh->bypass){
    brh->y0 = brh->y1;
    brh->y1 = brh->y2;
 }else{
    double ids = (x->reversed) ? -x->ids : x->ids;
    brh->y0.f1 = m->polarity * ids;
    brh->y0.f0 = brh->y0.x * brh->y0.f1;
    brh->y0.f0 = LINEAR;
 }
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
/* mos2_gmf: gate transconductance calculations forward mode
 * returns gm or 0
 */
/*--------------------------------------------------------------------------*/
/*ARGSUSED*/
void mos2_gmf0(branch_t *brh)
{;}
/*--------------------------------------------------------------------------*/
void mos2_gmf1(branch_t *brh)
{
 struct mos *x;
 
 x = (struct mos*)brh->parent->x;
 if (brh->bypass){
    brh->y0 = brh->y1;
    brh->y1 = brh->y2;
 }else{
    brh->y0.f1 = (x->reversed) ? 0. : x->gm;
    brh->y0.f0 = 0.;
 }
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
/* mos2_gmr: gate transconductance calculations reversed mode
 * returns gm or 0
 */
/*--------------------------------------------------------------------------*/
/*ARGSUSED*/
void mos2_gmr0(branch_t *brh)
{;}
/*--------------------------------------------------------------------------*/
void mos2_gmr1(branch_t *brh)
{
 struct mos *x;
 
 x = (struct mos*)brh->parent->x;
 if (brh->bypass){
    brh->y0 = brh->y1;
    brh->y1 = brh->y2;
 }else{
    brh->y0.f1 = (x->reversed) ? x->gm : 0.;
    brh->y0.f0 = 0.;
 }
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
/* mos2_gds: self-conductance calculations
 * returns gds
 */
/*--------------------------------------------------------------------------*/
/*ARGSUSED*/
void mos2_gds0(branch_t *brh)
{;}
/*--------------------------------------------------------------------------*/
void mos2_gds1(branch_t *brh)
{
 struct mos *x;
 
 x = (struct mos*)brh->parent->x;
 if (brh->bypass){
    brh->y0 = brh->y1;
    brh->y1 = brh->y2;
 }else{
    brh->y0.f1 = x->gds;
    brh->y0.f0 = 0.;
 }
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
/* mos2_gmbf: bulk transconductance calculations, forward mode
 * returns gmb or 0
 */
/*--------------------------------------------------------------------------*/
/*ARGSUSED*/
void mos2_gmbf0(branch_t *brh)
{;}
/*--------------------------------------------------------------------------*/
void mos2_gmbf1(branch_t *brh)
{
 struct mos *x;
 
 x = (struct mos*)brh->parent->x;
 if (brh->bypass){
    brh->y0 = brh->y1;
    brh->y1 = brh->y2;
 }else{
    brh->y0.f1 = (x->reversed) ? 0. : x->gmb;
    brh->y0.f0 = 0.;
 }
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
/* mos2_gmbr: bulk transconductance calculations, reversed mode
 * returns gmb or 0
 */
/*--------------------------------------------------------------------------*/
/*ARGSUSED*/
void mos2_gmbr0(branch_t *brh)
{;}
/*--------------------------------------------------------------------------*/
void mos2_gmbr1(branch_t *brh)
{
 struct mos *x;
 
 x = (struct mos*)brh->parent->x;
 if (brh->bypass){
    brh->y0 = brh->y1;
    brh->y1 = brh->y2;
 }else{
    brh->y0.f1 = (x->reversed) ? x->gmb : 0.;
    brh->y0.f0 = 0.;
 }
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
/* gate capacitors.  Meyer model.  
 * Refs: Antognetti, Divekar, Spice 2 & 3 code
 * final ref was Spice 2g6 code.
 * all agree except for typos and smoothing.  (yup!!)
 */
/*--------------------------------------------------------------------------*/
void mos_cgb0(branch_t *brh)
{
 brh->y0.f0 = brh->y0.x * brh->y0.f1;
}
/*--------------------------------------------------------------------------*/
void mos_cgb1(branch_t *brh)
{
 double c;
 struct mos *x;
 struct mmod *m;
 x = (struct mos*)brh->parent->x;
 m = x->m;
 
 c = brh->val;
 if (x->vgst < - m->phi){ 			/* accumulation */
    c += x->cgate;
 }else if (x->vgst < 0.){			/* depletion */
    c += x->cgate * (-x->vgst) / m->phi;
 }						/* active, overlap only */
 brh->y0.f1 = c;
 brh->y0.f0 = brh->y0.x * brh->y0.f1;
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
void mos_cgd0(branch_t *brh)
{
 brh->y0.f0 = brh->y0.x * brh->y0.f1;
}
/*--------------------------------------------------------------------------*/
void mos_cgd1(branch_t *brh)
{
 double c;
 struct mos *x;
 x = (struct mos*)brh->parent->x;

 c = brh->val;					/* start with overlap cap */
 if (x->vgst > x->vds){				/* linear */
    double vdif = 2. * x->vgst - x->vds;
    c += (2./3.) * x->cgate * (1. - (x->vgst*x->vgst)/(vdif*vdif));
 }						/* else overlap only */
 brh->y0.f1 = c;
 brh->y0.f0 = brh->y0.x * brh->y0.f1;
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
void mos_cgs0(branch_t *brh)
{
 brh->y0.f0 = brh->y0.x * brh->y0.f1;
}
/*--------------------------------------------------------------------------*/
void mos_cgs1(branch_t *brh)
{
 double c;
 struct mos *x;
 struct mmod *m;
 x = (struct mos*)brh->parent->x;
 m = x->m;

 c = brh->val;					/* start with overlap cap */
 if (x->vgst > x->vds){				/* linear */
    double numer = x->vgst - x->vds;
    double denom = 2. * x->vgst - x->vds;
    c += (2./3.) * x->cgate * (1. - (numer*numer)/(denom*denom));
 }else if (x->vgst > 0.){			/* saturation */
    c += (2./3.) * x->cgate;
 }else if (x->vgst > -m->phi/2.){		/* depletion */
    c += (2./3.) * x->cgate * ((x->vgst / (m->phi/2.)) + 1.);
 }						/* accum. = overlap only */
 brh->y0.f1 = c;
 brh->y0.f0 = brh->y0.x * brh->y0.f1;
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
